/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.annotations;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.XStream;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.annotations.XStreamAlias;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.annotations.XStreamContainedType;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.annotations.XStreamConverter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.annotations.XStreamConverters;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.annotations.XStreamImplicitCollection;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.Converter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class Annotations {
    private static final Set<Class<?>> visitedTypes = new HashSet();

    private Annotations() {
    }

    public static synchronized void configureAliases(XStream xstream, Class<?> ... topLevelClasses) {
        visitedTypes.clear();
        for (Class<?> topLevelClass : topLevelClasses) {
            Annotations.configureClass(xstream, topLevelClass);
        }
    }

    private static synchronized void configureClass(XStream xstream, Class<?> configurableClass) {
        Class<?>[] interfaces;
        if (configurableClass == null || visitedTypes.contains(configurableClass)) {
            return;
        }
        if (Converter.class.isAssignableFrom(configurableClass)) {
            Class<?> converterType = configurableClass;
            Annotations.registerConverter(xstream, converterType);
            return;
        }
        visitedTypes.add(configurableClass);
        Class<?> element = configurableClass;
        if (configurableClass.isAnnotationPresent(XStreamConverters.class)) {
            XStreamConverters convertersAnnotation = element.getAnnotation(XStreamConverters.class);
            for (XStreamConverter converterAnnotation : convertersAnnotation.value()) {
                Annotations.registerConverter(xstream, converterAnnotation.value());
            }
        }
        if (configurableClass.isAnnotationPresent(XStreamConverter.class)) {
            XStreamConverter converterAnnotation = element.getAnnotation(XStreamConverter.class);
            Annotations.registerConverter(xstream, converterAnnotation.value());
        }
        if (configurableClass.isAnnotationPresent(XStreamAlias.class)) {
            XStreamAlias aliasAnnotation = element.getAnnotation(XStreamAlias.class);
            if (aliasAnnotation.impl() != Void.class) {
                xstream.alias(aliasAnnotation.value(), configurableClass, aliasAnnotation.impl());
                if (configurableClass.isInterface()) {
                    Annotations.configureClass(xstream, aliasAnnotation.impl());
                    return;
                }
            } else {
                xstream.alias(aliasAnnotation.value(), configurableClass);
            }
        }
        if (configurableClass.isAnnotationPresent(XStreamImplicitCollection.class)) {
            XStreamImplicitCollection implicitColAnnotation = element.getAnnotation(XStreamImplicitCollection.class);
            String fieldName = implicitColAnnotation.value();
            String itemFieldName = implicitColAnnotation.item();
            try {
                Field field = configurableClass.getDeclaredField(fieldName);
                Class itemType = Annotations.getFieldParameterizedType(field, xstream);
                if (itemType == null) {
                    xstream.addImplicitCollection(configurableClass, fieldName);
                } else if (itemFieldName.equals("")) {
                    xstream.addImplicitCollection(configurableClass, fieldName, itemType);
                } else {
                    xstream.addImplicitCollection(configurableClass, fieldName, itemFieldName, itemType);
                }
            }
            catch (Exception e) {
                System.err.println("Fail to derive ImplicitCollection member type");
            }
        }
        Field[] fields = configurableClass.getDeclaredFields();
        for (Field field : fields) {
            if (field.isSynthetic()) continue;
            Class<?> fieldType = field.getType();
            if (Collection.class.isAssignableFrom(fieldType) && field.isAnnotationPresent(XStreamContainedType.class)) {
                Class containedClass = Annotations.getFieldParameterizedType(field, xstream);
                Annotations.configureClass(xstream, containedClass);
            }
            if (!field.isAnnotationPresent(XStreamAlias.class)) continue;
            XStreamAlias fieldXStreamAliasAnnotation = field.getAnnotation(XStreamAlias.class);
            xstream.aliasField(fieldXStreamAliasAnnotation.value(), configurableClass, field.getName());
            Annotations.configureClass(xstream, field.getType());
        }
        for (Class<?> memberClass : configurableClass.getDeclaredClasses()) {
            Annotations.configureClass(xstream, memberClass);
        }
        Class<?> superClass = configurableClass.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            Annotations.configureClass(xstream, superClass);
        }
        for (Class<?> intf : interfaces = configurableClass.getInterfaces()) {
            Annotations.configureClass(xstream, intf);
        }
    }

    private static void registerConverter(XStream xstream, Class<? extends Converter> converterType) {
        Converter converter;
        if (visitedTypes.contains(converterType)) {
            return;
        }
        visitedTypes.add(converterType);
        if (AbstractCollectionConverter.class.isAssignableFrom(converterType)) {
            try {
                Constructor<? extends Converter> converterConstructor = converterType.getConstructor(Mapper.class);
                converter = converterConstructor.newInstance(xstream.getMapper());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            converter = converterType.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        xstream.registerConverter(converter);
    }

    private static Class getFieldParameterizedType(Field field, XStream xstream) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)field.getGenericType();
            Class<?> type = (Class<?>)pType.getActualTypeArguments()[0];
            if (type.isInterface()) {
                Class<?> element = type;
                XStreamAlias alias = element.getAnnotation(XStreamAlias.class);
                Annotations.configureClass(xstream, type);
                type = alias.impl();
                assert (!type.isInterface()) : type;
            }
            return type;
        }
        assert (false) : "Field is raw type :" + field;
        return null;
    }
}

