/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.sun.jna.win32;

import org.jetbrains.jet.internal.com.sun.jna.DefaultTypeMapper;
import org.jetbrains.jet.internal.com.sun.jna.FromNativeContext;
import org.jetbrains.jet.internal.com.sun.jna.StringArray;
import org.jetbrains.jet.internal.com.sun.jna.ToNativeContext;
import org.jetbrains.jet.internal.com.sun.jna.TypeConverter;
import org.jetbrains.jet.internal.com.sun.jna.TypeMapper;
import org.jetbrains.jet.internal.com.sun.jna.WString;

public class W32APITypeMapper
extends DefaultTypeMapper {
    public static final TypeMapper UNICODE = new W32APITypeMapper(true);
    public static final TypeMapper ASCII = new W32APITypeMapper(false);
    static /* synthetic */ Class class$com$sun$jna$WString;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    protected W32APITypeMapper(boolean unicode) {
        if (unicode) {
            TypeConverter stringConverter = new TypeConverter(){

                @Override
                public Object toNative(Object value, ToNativeContext context) {
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof String[]) {
                        return new StringArray((String[])value, true);
                    }
                    return new WString(value.toString());
                }

                @Override
                public Object fromNative(Object value, FromNativeContext context) {
                    if (value == null) {
                        return null;
                    }
                    return value.toString();
                }

                @Override
                public Class nativeType() {
                    return class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = W32APITypeMapper.class$("org.jetbrains.jet.internal.com.sun.jna.WString")) : class$com$sun$jna$WString;
                }
            };
            this.addTypeConverter(class$java$lang$String == null ? (class$java$lang$String = W32APITypeMapper.class$("java.lang.String")) : class$java$lang$String, stringConverter);
            this.addToNativeConverter(array$Ljava$lang$String == null ? (array$Ljava$lang$String = W32APITypeMapper.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, stringConverter);
        }
        TypeConverter booleanConverter = new TypeConverter(){

            @Override
            public Object toNative(Object value, ToNativeContext context) {
                return new Integer(Boolean.TRUE.equals(value) ? 1 : 0);
            }

            @Override
            public Object fromNative(Object value, FromNativeContext context) {
                return (Integer)value != 0 ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Class nativeType() {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = W32APITypeMapper.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
        };
        this.addTypeConverter(class$java$lang$Boolean == null ? (class$java$lang$Boolean = W32APITypeMapper.class$("java.lang.Boolean")) : class$java$lang$Boolean, booleanConverter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

