/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.sun.jna;

import org.jetbrains.jet.internal.com.sun.jna.Pointer;
import org.jetbrains.jet.internal.com.sun.jna.Structure;
import org.jetbrains.jet.internal.com.sun.jna.TypeMapper;

public abstract class Union
extends Structure {
    private Structure.StructField activeField;
    Structure.StructField biggestField;

    protected Union() {
    }

    protected Union(Pointer p) {
        super(p);
    }

    protected Union(Pointer p, int alignType) {
        super(p, alignType);
    }

    protected Union(TypeMapper mapper) {
        super(mapper);
    }

    protected Union(Pointer p, int alignType, TypeMapper mapper) {
        super(p, alignType, mapper);
    }

    public void setType(Class type) {
        this.ensureAllocated();
        for (Structure.StructField f : this.fields().values()) {
            if (f.type != type) continue;
            this.activeField = f;
            return;
        }
        throw new IllegalArgumentException(new StringBuffer().append("No field of type ").append(type).append(" in ").append(this).toString());
    }

    public void setType(String fieldName) {
        this.ensureAllocated();
        Structure.StructField f = (Structure.StructField)this.fields().get(fieldName);
        if (f == null) {
            throw new IllegalArgumentException(new StringBuffer().append("No field named ").append(fieldName).append(" in ").append(this).toString());
        }
        this.activeField = f;
    }

    @Override
    public Object readField(String fieldName) {
        this.ensureAllocated();
        this.setType(fieldName);
        return super.readField(fieldName);
    }

    @Override
    public void writeField(String fieldName) {
        this.ensureAllocated();
        this.setType(fieldName);
        super.writeField(fieldName);
    }

    @Override
    public void writeField(String fieldName, Object value) {
        this.ensureAllocated();
        this.setType(fieldName);
        super.writeField(fieldName, value);
    }

    public Object getTypedValue(Class type) {
        this.ensureAllocated();
        for (Structure.StructField f : this.fields().values()) {
            if (f.type != type) continue;
            this.activeField = f;
            this.read();
            return this.getField(this.activeField);
        }
        throw new IllegalArgumentException(new StringBuffer().append("No field of type ").append(type).append(" in ").append(this).toString());
    }

    public Object setTypedValue(Object object) {
        Structure.StructField f = this.findField(object.getClass());
        if (f != null) {
            this.activeField = f;
            this.setField(f, object);
            return this;
        }
        throw new IllegalArgumentException(new StringBuffer().append("No field of type ").append(object.getClass()).append(" in ").append(this).toString());
    }

    private Structure.StructField findField(Class type) {
        this.ensureAllocated();
        for (Structure.StructField f : this.fields().values()) {
            if (!f.type.isAssignableFrom(type)) continue;
            return f;
        }
        return null;
    }

    @Override
    protected int getNativeAlignment(Class type, Object value, boolean isFirstElement) {
        return super.getNativeAlignment(type, value, true);
    }
}

