/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.sun.jna;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.jetbrains.jet.internal.com.sun.jna.Callback;
import org.jetbrains.jet.internal.com.sun.jna.CallbackReference;
import org.jetbrains.jet.internal.com.sun.jna.CallbackThreadInitializer;
import org.jetbrains.jet.internal.com.sun.jna.FromNativeConverter;
import org.jetbrains.jet.internal.com.sun.jna.Function;
import org.jetbrains.jet.internal.com.sun.jna.FunctionMapper;
import org.jetbrains.jet.internal.com.sun.jna.Library;
import org.jetbrains.jet.internal.com.sun.jna.NativeLibrary;
import org.jetbrains.jet.internal.com.sun.jna.NativeMappedConverter;
import org.jetbrains.jet.internal.com.sun.jna.Platform;
import org.jetbrains.jet.internal.com.sun.jna.Pointer;
import org.jetbrains.jet.internal.com.sun.jna.Structure;
import org.jetbrains.jet.internal.com.sun.jna.ToNativeConverter;
import org.jetbrains.jet.internal.com.sun.jna.TypeMapper;

public final class Native {
    private static String nativeLibraryPath;
    private static Map typeMappers;
    private static Map alignments;
    private static Map options;
    private static Map libraries;
    private static final Callback.UncaughtExceptionHandler DEFAULT_HANDLER;
    private static Callback.UncaughtExceptionHandler callbackExceptionHandler;
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    public static final int SIZE_T_SIZE;
    private static final Object finalizer;
    private static final ThreadLocal lastError;
    private static Map registeredClasses;
    private static Map registeredLibraries;
    private static Object unloader;
    static /* synthetic */ Class class$com$sun$jna$Library;
    static /* synthetic */ Class class$com$sun$jna$Callback;
    static /* synthetic */ Class class$com$sun$jna$TypeMapper;
    static /* synthetic */ Class class$com$sun$jna$Native;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$com$sun$jna$Structure;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByReference;
    static /* synthetic */ Class class$com$sun$jna$NativeMapped;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByValue;
    static /* synthetic */ Class class$com$sun$jna$Pointer;
    static /* synthetic */ Class class$com$sun$jna$WString;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$com$sun$jna$IntegerType;
    static /* synthetic */ Class class$com$sun$jna$PointerType;
    static /* synthetic */ Class class$com$sun$jna$LastErrorException;
    static /* synthetic */ Class class$java$nio$Buffer;

    private static void dispose() {
        NativeLibrary.disposeAll();
        nativeLibraryPath = null;
    }

    private static boolean deleteNativeLibrary(String path) {
        File flib = new File(path);
        if (flib.delete()) {
            return true;
        }
        Native.markTemporaryFile(flib);
        return false;
    }

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static synchronized native boolean isProtected();

    public static synchronized native void setPreserveLastError(boolean var0);

    public static synchronized native boolean getPreserveLastError();

    public static long getWindowID(Window w) throws HeadlessException {
        return AWT.getWindowID(w);
    }

    public static long getComponentID(Component c) throws HeadlessException {
        return AWT.getComponentID(c);
    }

    public static Pointer getWindowPointer(Window w) throws HeadlessException {
        return new Pointer(AWT.getWindowID(w));
    }

    public static Pointer getComponentPointer(Component c) throws HeadlessException {
        return new Pointer(AWT.getComponentID(c));
    }

    static native long getWindowHandle0(Component var0);

    public static Pointer getDirectBufferPointer(Buffer b) {
        long peer = Native._getDirectBufferPointer(b);
        return peer == 0L ? null : new Pointer(peer);
    }

    private static native long _getDirectBufferPointer(Buffer var0);

    public static String toString(byte[] buf) {
        return Native.toString(buf, System.getProperty("jna.encoding"));
    }

    public static String toString(byte[] buf, String encoding) {
        int term;
        String s = null;
        if (encoding != null) {
            try {
                s = new String(buf, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (s == null) {
            s = new String(buf);
        }
        if ((term = s.indexOf(0)) != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static String toString(char[] buf) {
        String s = new String(buf);
        int term = s.indexOf(0);
        if (term != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static Object loadLibrary(Class interfaceClass) {
        return Native.loadLibrary(null, interfaceClass);
    }

    public static Object loadLibrary(Class interfaceClass, Map options) {
        return Native.loadLibrary(null, interfaceClass, options);
    }

    public static Object loadLibrary(String name, Class interfaceClass) {
        return Native.loadLibrary(name, interfaceClass, Collections.EMPTY_MAP);
    }

    public static Object loadLibrary(String name, Class interfaceClass, Map options) {
        Library.Handler handler = new Library.Handler(name, interfaceClass, options);
        ClassLoader loader = interfaceClass.getClassLoader();
        Library proxy = (Library)Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        Native.cacheOptions(interfaceClass, options, proxy);
        return proxy;
    }

    private static void loadLibraryInstance(Class cls) {
        if (cls != null && !libraries.containsKey(cls)) {
            try {
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (field.getType() != cls || !Modifier.isStatic(field.getModifiers())) continue;
                    libraries.put(cls, new WeakReference<Object>(field.get(null)));
                    break;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuffer().append("Could not access instance of ").append(cls).append(" (").append(e).append(")").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class findEnclosingLibraryClass(Class cls) {
        Class<?> declaring;
        Class fromDeclaring;
        if (cls == null) {
            return null;
        }
        Map map = libraries;
        synchronized (map) {
            if (options.containsKey(cls)) {
                return cls;
            }
        }
        if ((class$com$sun$jna$Library == null ? (class$com$sun$jna$Library = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Library")) : class$com$sun$jna$Library).isAssignableFrom(cls)) {
            return cls;
        }
        if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls)) {
            cls = CallbackReference.findCallbackClass(cls);
        }
        if ((fromDeclaring = Native.findEnclosingLibraryClass(declaring = cls.getDeclaringClass())) != null) {
            return fromDeclaring;
        }
        return Native.findEnclosingLibraryClass(cls.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLibraryOptions(Class type) {
        Map map = libraries;
        synchronized (map) {
            Class interfaceClass = Native.findEnclosingLibraryClass(type);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = type;
            }
            if (!options.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("OPTIONS");
                    field.setAccessible(true);
                    options.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException field) {
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(new StringBuffer().append("OPTIONS must be a public field of type java.util.Map (").append(e).append("): ").append(interfaceClass).toString());
                }
            }
            return (Map)options.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeMapper getTypeMapper(Class cls) {
        Map map = libraries;
        synchronized (map) {
            Class interfaceClass = Native.findEnclosingLibraryClass(cls);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = cls;
            }
            if (!typeMappers.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("TYPE_MAPPER");
                    field.setAccessible(true);
                    typeMappers.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e) {
                    Map options = Native.getLibraryOptions(cls);
                    if (options != null && options.containsKey("type-mapper")) {
                        typeMappers.put(interfaceClass, options.get("type-mapper"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(new StringBuffer().append("TYPE_MAPPER must be a public field of type ").append((class$com$sun$jna$TypeMapper == null ? (class$com$sun$jna$TypeMapper = Native.class$("org.jetbrains.jet.internal.com.sun.jna.TypeMapper")) : class$com$sun$jna$TypeMapper).getName()).append(" (").append(e).append("): ").append(interfaceClass).toString());
                }
            }
            return (TypeMapper)typeMappers.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStructureAlignment(Class cls) {
        Map map = libraries;
        synchronized (map) {
            Integer value;
            Class interfaceClass = Native.findEnclosingLibraryClass(cls);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = cls;
            }
            if (!alignments.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("STRUCTURE_ALIGNMENT");
                    field.setAccessible(true);
                    alignments.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e) {
                    Map options = Native.getLibraryOptions(interfaceClass);
                    if (options != null && options.containsKey("structure-alignment")) {
                        alignments.put(interfaceClass, options.get("structure-alignment"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(new StringBuffer().append("STRUCTURE_ALIGNMENT must be a public field of type int (").append(e).append("): ").append(interfaceClass).toString());
                }
            }
            int n = (value = (Integer)alignments.get(interfaceClass)) != null ? value : 0;
            return n;
        }
    }

    static byte[] getBytes(String s) {
        try {
            return Native.getBytes(s, System.getProperty("jna.encoding"));
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    static byte[] getBytes(String s, String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return s.getBytes(encoding);
        }
        return s.getBytes();
    }

    public static byte[] toByteArray(String s) {
        byte[] bytes = Native.getBytes(s);
        byte[] buf = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, buf, 0, bytes.length);
        return buf;
    }

    public static byte[] toByteArray(String s, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = Native.getBytes(s, encoding);
        byte[] buf = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, buf, 0, bytes.length);
        return buf;
    }

    public static char[] toCharArray(String s) {
        char[] chars = s.toCharArray();
        char[] buf = new char[chars.length + 1];
        System.arraycopy(chars, 0, buf, 0, chars.length);
        return buf;
    }

    static String getNativeLibraryResourcePath(int osType, String arch, String name) {
        String osPrefix;
        if ("powerpc".equals(arch = arch.toLowerCase())) {
            arch = "ppc";
        } else if ("powerpc64".equals(arch)) {
            arch = "ppc64";
        }
        switch (osType) {
            case 2: {
                if ("i386".equals(arch)) {
                    arch = "x86";
                }
                osPrefix = new StringBuffer().append("win32-").append(arch).toString();
                break;
            }
            case 6: {
                osPrefix = new StringBuffer().append("w32ce-").append(arch).toString();
                break;
            }
            case 0: {
                osPrefix = "darwin";
                break;
            }
            case 1: {
                if ("x86".equals(arch)) {
                    arch = "i386";
                } else if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                osPrefix = new StringBuffer().append("linux-").append(arch).toString();
                break;
            }
            case 3: {
                osPrefix = new StringBuffer().append("sunos-").append(arch).toString();
                break;
            }
            default: {
                int space;
                osPrefix = name.toLowerCase();
                if ("x86".equals(arch)) {
                    arch = "i386";
                }
                if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                if ((space = osPrefix.indexOf(" ")) != -1) {
                    osPrefix = osPrefix.substring(0, space);
                }
                osPrefix = new StringBuffer().append(osPrefix).append("-").append(arch).toString();
            }
        }
        return new StringBuffer().append("/org/jetbrains/jet/internal/com/sun/jna/").append(osPrefix).toString();
    }

    private static void loadNativeLibrary() {
        block13: {
            Native.removeTemporaryFiles();
            String libName = System.getProperty("jna.boot.library.name", "jnidispatch");
            String bootPath = System.getProperty("jna.boot.library.path");
            if (bootPath != null) {
                StringTokenizer dirs = new StringTokenizer(bootPath, File.pathSeparator);
                while (dirs.hasMoreTokens()) {
                    String ext;
                    String orig;
                    String dir = dirs.nextToken();
                    File file = new File(new File(dir), System.mapLibraryName(libName));
                    String path = file.getAbsolutePath();
                    if (file.exists()) {
                        try {
                            System.load(path);
                            nativeLibraryPath = path;
                            return;
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            // empty catch block
                        }
                    }
                    if (!Platform.isMac()) continue;
                    if (path.endsWith("dylib")) {
                        orig = "dylib";
                        ext = "jnilib";
                    } else {
                        orig = "jnilib";
                        ext = "dylib";
                    }
                    if (!new File(path = new StringBuffer().append(path.substring(0, path.lastIndexOf(orig))).append(ext).toString()).exists()) continue;
                    try {
                        System.load(path);
                        nativeLibraryPath = path;
                        return;
                    }
                    catch (UnsatisfiedLinkError ex) {
                        System.err.println(new StringBuffer().append("File found at ").append(path).append(" but not loadable: ").append(ex.getMessage()).toString());
                    }
                }
            }
            try {
                if (!Boolean.getBoolean("jna.nosys")) {
                    System.loadLibrary(libName);
                    return;
                }
            }
            catch (UnsatisfiedLinkError e) {
                if (!Boolean.getBoolean("jna.nounpack")) break block13;
                throw e;
            }
        }
        if (!Boolean.getBoolean("jna.nounpack")) {
            Native.loadNativeLibraryFromJar();
            return;
        }
        throw new UnsatisfiedLinkError("Native jnidispatch library not found");
    }

    private static void loadNativeLibraryFromJar() {
        String libname = System.mapLibraryName("jnidispatch");
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String resourceName = new StringBuffer().append(Native.getNativeLibraryResourcePath(Platform.getOSType(), arch, name)).append("/").append(libname).toString();
        URL url = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Native")) : class$com$sun$jna$Native).getResource(resourceName);
        boolean unpacked = false;
        if (url == null && Platform.isMac() && resourceName.endsWith(".dylib")) {
            resourceName = new StringBuffer().append(resourceName.substring(0, resourceName.lastIndexOf(".dylib"))).append(".jnilib").toString();
            url = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Native")) : class$com$sun$jna$Native).getResource(resourceName);
        }
        if (url == null) {
            throw new UnsatisfiedLinkError(new StringBuffer().append("jnidispatch (").append(resourceName).append(") not found in resource path").toString());
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                lib = new File(url.getPath());
            }
            if (!lib.exists()) {
                throw new Error(new StringBuffer().append("File URL ").append(url).append(" could not be properly decoded").toString());
            }
        } else {
            InputStream is = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Native")) : class$com$sun$jna$Native).getResourceAsStream(resourceName);
            if (is == null) {
                throw new Error("Can't obtain jnidispatch InputStream");
            }
            FileOutputStream fos = null;
            try {
                int count;
                File dir = Native.getTempDir();
                lib = File.createTempFile("jna", Platform.isWindows() ? ".dll" : null, dir);
                lib.deleteOnExit();
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[1024];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
                unpacked = true;
            }
            catch (IOException e) {
                throw new Error(new StringBuffer().append("Failed to create temporary file for jnidispatch library: ").append(e).toString());
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        System.load(lib.getAbsolutePath());
        nativeLibraryPath = lib.getAbsolutePath();
        if (unpacked) {
            Native.deleteNativeLibrary(lib.getAbsolutePath());
        }
    }

    private static native int sizeof(int var0);

    private static native String getNativeVersion();

    private static native String getAPIChecksum();

    public static int getLastError() {
        return (Integer)lastError.get();
    }

    public static native void setLastError(int var0);

    public static Library synchronizedLibrary(final Library library) {
        Class<?> cls = library.getClass();
        if (!Proxy.isProxyClass(cls)) {
            throw new IllegalArgumentException("Library must be a proxy class");
        }
        InvocationHandler ih = Proxy.getInvocationHandler(library);
        if (!(ih instanceof Library.Handler)) {
            throw new IllegalArgumentException(new StringBuffer().append("Unrecognized proxy handler: ").append(ih).toString());
        }
        final Library.Handler handler = (Library.Handler)ih;
        InvocationHandler newHandler = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                synchronized (nativeLibrary) {
                    return handler.invoke(library, method, args);
                }
            }
        };
        return (Library)Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), newHandler);
    }

    public static String getWebStartLibraryPath(String libName) {
        if (System.getProperty("javawebstart.version") == null) {
            return null;
        }
        try {
            ClassLoader cl = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Native")) : class$com$sun$jna$Native).getClassLoader();
            Method m = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method m = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Native.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("findLibrary", class$java$lang$String == null ? (class$java$lang$String = Native.class$("java.lang.String")) : class$java$lang$String);
                        m.setAccessible(true);
                        return m;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            String libpath = (String)m.invoke((Object)cl, libName);
            if (libpath != null) {
                return new File(libpath).getParent();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static void markTemporaryFile(File file) {
        try {
            File marker = new File(file.getParentFile(), new StringBuffer().append(file.getName()).append(".x").toString());
            marker.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static File getTempDir() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File jnatmp = new File(tmp, "jna");
        jnatmp.mkdirs();
        return jnatmp.exists() ? jnatmp : tmp;
    }

    static void removeTemporaryFiles() {
        File dir = Native.getTempDir();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".x") && name.indexOf("jna") != -1;
            }
        };
        File[] files = dir.listFiles(filter);
        for (int i = 0; files != null && i < files.length; ++i) {
            File marker = files[i];
            String name = marker.getName();
            name = name.substring(0, name.length() - 2);
            File target = new File(marker.getParentFile(), name);
            if (target.exists() && !target.delete()) continue;
            marker.delete();
        }
    }

    public static int getNativeSize(Class type, Object value) {
        if (type.isArray()) {
            int len = Array.getLength(value);
            if (len > 0) {
                Object o = Array.get(value, 0);
                return len * Native.getNativeSize(type.getComponentType(), o);
            }
            throw new IllegalArgumentException(new StringBuffer().append("Arrays of length zero not allowed: ").append(type).toString());
        }
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(type) && !(class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type)) {
            if (value == null) {
                value = Structure.newInstance(type);
            }
            return ((Structure)value).size();
        }
        try {
            return Native.getNativeSize(type);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(new StringBuffer().append("The type \"").append(type.getName()).append("\" is not supported: ").append(e.getMessage()).toString());
        }
    }

    public static int getNativeSize(Class cls) {
        if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Native.class$("org.jetbrains.jet.internal.com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls == Boolean.TYPE || cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Native.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 4;
        }
        if (cls == Byte.TYPE || cls == (class$java$lang$Byte == null ? (class$java$lang$Byte = Native.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 1;
        }
        if (cls == Short.TYPE || cls == (class$java$lang$Short == null ? (class$java$lang$Short = Native.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 2;
        }
        if (cls == Character.TYPE || cls == (class$java$lang$Character == null ? (class$java$lang$Character = Native.class$("java.lang.Character")) : class$java$lang$Character)) {
            return WCHAR_SIZE;
        }
        if (cls == Integer.TYPE || cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = Native.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 4;
        }
        if (cls == Long.TYPE || cls == (class$java$lang$Long == null ? (class$java$lang$Long = Native.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 8;
        }
        if (cls == Float.TYPE || cls == (class$java$lang$Float == null ? (class$java$lang$Float = Native.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 4;
        }
        if (cls == Double.TYPE || cls == (class$java$lang$Double == null ? (class$java$lang$Double = Native.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 8;
        }
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
            if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(cls)) {
                return Structure.newInstance(cls).size();
            }
            return POINTER_SIZE;
        }
        if ((class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Pointer")) : class$com$sun$jna$Pointer).isAssignableFrom(cls) || Platform.HAS_BUFFERS && Buffers.isBuffer(cls) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls) || (class$java$lang$String == null ? (class$java$lang$String = Native.class$("java.lang.String")) : class$java$lang$String) == cls || (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Native.class$("org.jetbrains.jet.internal.com.sun.jna.WString")) : class$com$sun$jna$WString) == cls) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Native size for type \"").append(cls.getName()).append("\" is unknown").toString());
    }

    public static boolean isSupportedNativeType(Class cls) {
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
            return true;
        }
        try {
            return Native.getNativeSize(cls) != 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void setCallbackExceptionHandler(Callback.UncaughtExceptionHandler eh) {
        callbackExceptionHandler = eh == null ? DEFAULT_HANDLER : eh;
    }

    public static Callback.UncaughtExceptionHandler getCallbackExceptionHandler() {
        return callbackExceptionHandler;
    }

    public static void register(String libName) {
        Native.register(Native.getNativeClass(Native.getCallingClass()), NativeLibrary.getInstance(libName));
    }

    public static void register(NativeLibrary lib) {
        Native.register(Native.getNativeClass(Native.getCallingClass()), lib);
    }

    static Class getNativeClass(Class cls) {
        Method[] methods = cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if ((methods[i].getModifiers() & 0x100) == 0) continue;
            return cls;
        }
        int idx = cls.getName().lastIndexOf("$");
        if (idx != -1) {
            String name = cls.getName().substring(0, idx);
            try {
                return Native.getNativeClass(Class.forName(name, true, cls.getClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(new StringBuffer().append("Can't determine class with native methods from the current context (").append(cls).append(")").toString());
    }

    static Class getCallingClass() {
        Class[] context = new SecurityManager(){

            public Class[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (context.length < 4) {
            throw new IllegalStateException("This method must be called from the static initializer of a class");
        }
        return context[3];
    }

    public static void setCallbackThreadInitializer(Callback cb, CallbackThreadInitializer initializer) {
        CallbackReference.setCallbackThreadInitializer(cb, initializer);
    }

    public static void unregister() {
        Native.unregister(Native.getNativeClass(Native.getCallingClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Class cls) {
        Map map = registeredClasses;
        synchronized (map) {
            if (registeredClasses.containsKey(cls)) {
                Native.unregister(cls, (long[])registeredClasses.get(cls));
                registeredClasses.remove(cls);
                registeredLibraries.remove(cls);
            }
        }
    }

    private static native void unregister(Class var0, long[] var1);

    private static String getSignature(Class cls) {
        if (cls.isArray()) {
            return new StringBuffer().append("[").append(Native.getSignature(cls.getComponentType())).toString();
        }
        if (cls.isPrimitive()) {
            if (cls == Void.TYPE) {
                return "V";
            }
            if (cls == Boolean.TYPE) {
                return "Z";
            }
            if (cls == Byte.TYPE) {
                return "B";
            }
            if (cls == Short.TYPE) {
                return "S";
            }
            if (cls == Character.TYPE) {
                return "C";
            }
            if (cls == Integer.TYPE) {
                return "I";
            }
            if (cls == Long.TYPE) {
                return "J";
            }
            if (cls == Float.TYPE) {
                return "F";
            }
            if (cls == Double.TYPE) {
                return "D";
            }
        }
        return new StringBuffer().append("L").append(Native.replace(".", "/", cls.getName())).append(";").toString();
    }

    static String replace(String s1, String s2, String str) {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int idx;
            if ((idx = str.indexOf(s1)) == -1) break;
            buf.append(str.substring(0, idx));
            buf.append(s2);
            str = str.substring(idx + s1.length());
        }
        buf.append(str);
        return buf.toString();
    }

    private static int getConversion(Class type, TypeMapper mapper) {
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Native.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            type = Boolean.TYPE;
        } else if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = Native.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            type = Byte.TYPE;
        } else if (type == (class$java$lang$Short == null ? (class$java$lang$Short = Native.class$("java.lang.Short")) : class$java$lang$Short)) {
            type = Short.TYPE;
        } else if (type == (class$java$lang$Character == null ? (class$java$lang$Character = Native.class$("java.lang.Character")) : class$java$lang$Character)) {
            type = Character.TYPE;
        } else if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = Native.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            type = Integer.TYPE;
        } else if (type == (class$java$lang$Long == null ? (class$java$lang$Long = Native.class$("java.lang.Long")) : class$java$lang$Long)) {
            type = Long.TYPE;
        } else if (type == (class$java$lang$Float == null ? (class$java$lang$Float = Native.class$("java.lang.Float")) : class$java$lang$Float)) {
            type = Float.TYPE;
        } else if (type == (class$java$lang$Double == null ? (class$java$lang$Double = Native.class$("java.lang.Double")) : class$java$lang$Double)) {
            type = Double.TYPE;
        } else if (type == (class$java$lang$Void == null ? (class$java$lang$Void = Native.class$("java.lang.Void")) : class$java$lang$Void)) {
            type = Void.TYPE;
        }
        if (mapper != null && (mapper.getFromNativeConverter(type) != null || mapper.getToNativeConverter(type) != null)) {
            return 21;
        }
        if ((class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Pointer")) : class$com$sun$jna$Pointer).isAssignableFrom(type)) {
            return 1;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = Native.class$("java.lang.String")) : class$java$lang$String) == type) {
            return 2;
        }
        if ((class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Native.class$("org.jetbrains.jet.internal.com.sun.jna.WString")) : class$com$sun$jna$WString).isAssignableFrom(type)) {
            return 18;
        }
        if (Platform.HAS_BUFFERS && Buffers.isBuffer(type)) {
            return 5;
        }
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(type)) {
            if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(type)) {
                return 4;
            }
            return 3;
        }
        if (type.isArray()) {
            switch (type.getName().charAt(1)) {
                case 'Z': {
                    return 13;
                }
                case 'B': {
                    return 6;
                }
                case 'S': {
                    return 7;
                }
                case 'C': {
                    return 8;
                }
                case 'I': {
                    return 9;
                }
                case 'J': {
                    return 10;
                }
                case 'F': {
                    return 11;
                }
                case 'D': {
                    return 12;
                }
            }
        }
        if (type.isPrimitive()) {
            return type == Boolean.TYPE ? 14 : 0;
        }
        if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(type)) {
            return 15;
        }
        if ((class$com$sun$jna$IntegerType == null ? (class$com$sun$jna$IntegerType = Native.class$("org.jetbrains.jet.internal.com.sun.jna.IntegerType")) : class$com$sun$jna$IntegerType).isAssignableFrom(type)) {
            return 19;
        }
        if ((class$com$sun$jna$PointerType == null ? (class$com$sun$jna$PointerType = Native.class$("org.jetbrains.jet.internal.com.sun.jna.PointerType")) : class$com$sun$jna$PointerType).isAssignableFrom(type)) {
            return 20;
        }
        if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Native.class$("org.jetbrains.jet.internal.com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(type)) {
            return 17;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Class cls, NativeLibrary lib) {
        Method[] methods = cls.getDeclaredMethods();
        ArrayList<Method> mlist = new ArrayList<Method>();
        TypeMapper mapper = (TypeMapper)lib.getOptions().get("type-mapper");
        for (int i = 0; i < methods.length; ++i) {
            if ((methods[i].getModifiers() & 0x100) == 0) continue;
            mlist.add(methods[i]);
        }
        long[] handles = new long[mlist.size()];
        for (int i = 0; i < handles.length; ++i) {
            long rtype;
            long closure_rtype;
            Method method = (Method)mlist.get(i);
            String sig = "(";
            Class<?> rclass = method.getReturnType();
            Class<?>[] ptypes = method.getParameterTypes();
            long[] atypes = new long[ptypes.length];
            long[] closure_atypes = new long[ptypes.length];
            int[] cvt = new int[ptypes.length];
            ToNativeConverter[] toNative = new ToNativeConverter[ptypes.length];
            FromNativeConverter fromNative = null;
            int rcvt = Native.getConversion(rclass, mapper);
            boolean throwLastError = false;
            switch (rcvt) {
                case -1: {
                    throw new IllegalArgumentException(new StringBuffer().append(rclass).append(" is not a supported return type (in method ").append(method.getName()).append(" in ").append(cls).append(")").toString());
                }
                case 21: {
                    fromNative = mapper.getFromNativeConverter(rclass);
                    closure_rtype = Structure.FFIType.get(rclass).peer;
                    rtype = Structure.FFIType.get((Object)fromNative.nativeType()).peer;
                    break;
                }
                case 17: 
                case 19: 
                case 20: {
                    closure_rtype = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"org.jetbrains.jet.internal.com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    rtype = Structure.FFIType.get((Object)NativeMappedConverter.getInstance(rclass).nativeType()).peer;
                    break;
                }
                case 3: {
                    closure_rtype = rtype = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"org.jetbrains.jet.internal.com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    break;
                }
                case 4: {
                    closure_rtype = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"org.jetbrains.jet.internal.com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    rtype = Structure.FFIType.get(rclass).peer;
                    break;
                }
                default: {
                    closure_rtype = rtype = Structure.FFIType.get(rclass).peer;
                }
            }
            block19: for (int t = 0; t < ptypes.length; ++t) {
                Class type = ptypes[t];
                sig = new StringBuffer().append(sig).append(Native.getSignature(type)).toString();
                cvt[t] = Native.getConversion(type, mapper);
                if (cvt[t] == -1) {
                    throw new IllegalArgumentException(new StringBuffer().append(type).append(" is not a supported argument type (in method ").append(method.getName()).append(" in ").append(cls).append(")").toString());
                }
                if (cvt[t] == 17 || cvt[t] == 19) {
                    type = NativeMappedConverter.getInstance(type).nativeType();
                } else if (cvt[t] == 21) {
                    toNative[t] = mapper.getToNativeConverter(type);
                }
                switch (cvt[t]) {
                    case 4: 
                    case 17: 
                    case 19: 
                    case 20: {
                        atypes[t] = Structure.FFIType.get((Object)type).peer;
                        closure_atypes[t] = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"org.jetbrains.jet.internal.com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                        continue block19;
                    }
                    case 21: {
                        closure_atypes[t] = type.isPrimitive() ? Structure.FFIType.get((Object)type).peer : Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"org.jetbrains.jet.internal.com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                        atypes[t] = Structure.FFIType.get((Object)toNative[t].nativeType()).peer;
                        continue block19;
                    }
                    case 0: {
                        closure_atypes[t] = atypes[t] = Structure.FFIType.get((Object)type).peer;
                        continue block19;
                    }
                    default: {
                        closure_atypes[t] = atypes[t] = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"org.jetbrains.jet.internal.com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    }
                }
            }
            sig = new StringBuffer().append(sig).append(")").toString();
            sig = new StringBuffer().append(sig).append(Native.getSignature(rclass)).toString();
            Class<?>[] etypes = method.getExceptionTypes();
            for (int e = 0; e < etypes.length; ++e) {
                if (!(class$com$sun$jna$LastErrorException == null ? Native.class$("org.jetbrains.jet.internal.com.sun.jna.LastErrorException") : class$com$sun$jna$LastErrorException).isAssignableFrom(etypes[e])) continue;
                throwLastError = true;
                break;
            }
            String name = method.getName();
            FunctionMapper fmapper = (FunctionMapper)lib.getOptions().get("function-mapper");
            if (fmapper != null) {
                name = fmapper.getFunctionName(lib, method);
            }
            Function f = lib.getFunction(name, method);
            try {
                handles[i] = Native.registerMethod(cls, method.getName(), sig, cvt, closure_atypes, atypes, rcvt, closure_rtype, rtype, rclass, f.peer, f.getCallingConvention(), throwLastError, toNative, fromNative);
                continue;
            }
            catch (NoSuchMethodError e) {
                throw new UnsatisfiedLinkError(new StringBuffer().append("No method ").append(method.getName()).append(" with signature ").append(sig).append(" in ").append(cls).toString());
            }
        }
        Map map = registeredClasses;
        synchronized (map) {
            registeredClasses.put(cls, handles);
            registeredLibraries.put(cls, lib);
        }
        Native.cacheOptions(cls, lib.getOptions(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheOptions(Class cls, Map libOptions, Object proxy) {
        Map map = libraries;
        synchronized (map) {
            if (!libOptions.isEmpty()) {
                options.put(cls, libOptions);
            }
            if (libOptions.containsKey("type-mapper")) {
                typeMappers.put(cls, libOptions.get("type-mapper"));
            }
            if (libOptions.containsKey("structure-alignment")) {
                alignments.put(cls, libOptions.get("structure-alignment"));
            }
            if (proxy != null) {
                libraries.put(cls, new WeakReference<Object>(proxy));
            }
            if (!cls.isInterface() && (class$com$sun$jna$Library == null ? (class$com$sun$jna$Library = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Library")) : class$com$sun$jna$Library).isAssignableFrom(cls)) {
                Class<?>[] ifaces = cls.getInterfaces();
                for (int i = 0; i < ifaces.length; ++i) {
                    if (!(class$com$sun$jna$Library == null ? Native.class$("org.jetbrains.jet.internal.com.sun.jna.Library") : class$com$sun$jna$Library).isAssignableFrom(ifaces[i])) continue;
                    Native.cacheOptions(ifaces[i], libOptions, proxy);
                    break;
                }
            }
        }
    }

    private static native long registerMethod(Class var0, String var1, String var2, int[] var3, long[] var4, long[] var5, int var6, long var7, long var9, Class var11, long var12, int var14, boolean var15, ToNativeConverter[] var16, FromNativeConverter var17);

    public static native long ffi_prep_cif(int var0, int var1, long var2, long var4);

    public static native void ffi_call(long var0, long var2, long var4, long var6);

    public static native long ffi_prep_closure(long var0, ffi_callback var2);

    public static native void ffi_free_closure(long var0);

    public static void main(String[] args) {
        String version;
        String title;
        String DEFAULT_TITLE = "Java Native Access (JNA)";
        String DEFAULT_VERSION = "3.4.0";
        String DEFAULT_BUILD = "3.4.0 (package information missing)";
        Package pkg = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("org.jetbrains.jet.internal.com.sun.jna.Native")) : class$com$sun$jna$Native).getPackage();
        String string = title = pkg != null ? pkg.getSpecificationTitle() : "Java Native Access (JNA)";
        if (title == null) {
            title = "Java Native Access (JNA)";
        }
        String string2 = version = pkg != null ? pkg.getSpecificationVersion() : "3.4.0";
        if (version == null) {
            version = "3.4.0";
        }
        title = new StringBuffer().append(title).append(" API Version ").append(version).toString();
        System.out.println(title);
        String string3 = version = pkg != null ? pkg.getImplementationVersion() : "3.4.0 (package information missing)";
        if (version == null) {
            version = "3.4.0 (package information missing)";
        }
        System.out.println(new StringBuffer().append("Version: ").append(version).toString());
        System.out.println(new StringBuffer().append(" Native: ").append(Native.getNativeVersion()).append(" (").append(Native.getAPIChecksum()).append(")").toString());
        System.exit(0);
    }

    static synchronized native void freeNativeCallback(long var0);

    static synchronized native long createNativeCallback(Callback var0, Method var1, Class[] var2, Class var3, int var4, boolean var5);

    static native int invokeInt(long var0, int var2, Object[] var3);

    static native long invokeLong(long var0, int var2, Object[] var3);

    static native void invokeVoid(long var0, int var2, Object[] var3);

    static native float invokeFloat(long var0, int var2, Object[] var3);

    static native double invokeDouble(long var0, int var2, Object[] var3);

    static native long invokePointer(long var0, int var2, Object[] var3);

    private static native void invokeStructure(long var0, int var2, Object[] var3, long var4, long var6);

    static Structure invokeStructure(long fp, int callFlags, Object[] args, Structure s) {
        Native.invokeStructure(fp, callFlags, args, s.getPointer().peer, s.getTypeInfo().peer);
        return s;
    }

    static native Object invokeObject(long var0, int var2, Object[] var3);

    static native long open(String var0);

    static native void close(long var0);

    static native long findSymbol(long var0, String var2);

    static native long indexOf(long var0, byte var2);

    static native void read(long var0, byte[] var2, int var3, int var4);

    static native void read(long var0, short[] var2, int var3, int var4);

    static native void read(long var0, char[] var2, int var3, int var4);

    static native void read(long var0, int[] var2, int var3, int var4);

    static native void read(long var0, long[] var2, int var3, int var4);

    static native void read(long var0, float[] var2, int var3, int var4);

    static native void read(long var0, double[] var2, int var3, int var4);

    static native void write(long var0, byte[] var2, int var3, int var4);

    static native void write(long var0, short[] var2, int var3, int var4);

    static native void write(long var0, char[] var2, int var3, int var4);

    static native void write(long var0, int[] var2, int var3, int var4);

    static native void write(long var0, long[] var2, int var3, int var4);

    static native void write(long var0, float[] var2, int var3, int var4);

    static native void write(long var0, double[] var2, int var3, int var4);

    static native byte getByte(long var0);

    static native char getChar(long var0);

    static native short getShort(long var0);

    static native int getInt(long var0);

    static native long getLong(long var0);

    static native float getFloat(long var0);

    static native double getDouble(long var0);

    static Pointer getPointer(long addr) {
        long peer = Native._getPointer(addr);
        return peer == 0L ? null : new Pointer(peer);
    }

    private static native long _getPointer(long var0);

    static native String getString(long var0, boolean var2);

    static native void setMemory(long var0, long var2, byte var4);

    static native void setByte(long var0, byte var2);

    static native void setShort(long var0, short var2);

    static native void setChar(long var0, char var2);

    static native void setInt(long var0, int var2);

    static native void setLong(long var0, long var2);

    static native void setFloat(long var0, float var2);

    static native void setDouble(long var0, double var2);

    static native void setPointer(long var0, long var2);

    static native void setString(long var0, String var2, boolean var3);

    public static native long malloc(long var0);

    public static native void free(long var0);

    public static native ByteBuffer getDirectByteBuffer(long var0, long var2);

    public static void detach(boolean detach) {
        Native.setLastError(detach ? -1 : -2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        String version;
        nativeLibraryPath = null;
        typeMappers = new WeakHashMap();
        alignments = new WeakHashMap();
        options = new WeakHashMap();
        libraries = new WeakHashMap();
        callbackExceptionHandler = DEFAULT_HANDLER = new Callback.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Callback c, Throwable e) {
                System.err.println(new StringBuffer().append("JNA: Callback ").append(c).append(" threw the following exception:").toString());
                e.printStackTrace();
            }
        };
        Native.loadNativeLibrary();
        POINTER_SIZE = Native.sizeof(0);
        LONG_SIZE = Native.sizeof(1);
        WCHAR_SIZE = Native.sizeof(2);
        SIZE_T_SIZE = Native.sizeof(3);
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
        if (!"3.4.0".equals(version = Native.getNativeVersion())) {
            String LS = System.getProperty("line.separator");
            throw new Error(new StringBuffer().append(LS).append(LS).append("There is an incompatible JNA native library installed on this system.").append(LS).append("To resolve this issue you may do one of the following:").append(LS).append(" - remove or uninstall the offending library").append(LS).append(" - set the system property jna.nosys=true").append(LS).append(" - set jna.boot.library.path to include the path to the version of the ").append(LS).append("   jnidispatch library included with the JNA jar file you are using").append(LS).toString());
        }
        Native.setPreserveLastError("true".equalsIgnoreCase(System.getProperty("jna.preserve_last_error", "true")));
        finalizer = new Object(){

            protected void finalize() {
                Native.dispose();
            }
        };
        lastError = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(0);
            }
        };
        registeredClasses = new HashMap();
        registeredLibraries = new HashMap();
        unloader = new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() {
                Map map = registeredClasses;
                synchronized (map) {
                    Iterator i = registeredClasses.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        Native.unregister((Class)e.getKey(), (long[])e.getValue());
                        i.remove();
                    }
                }
            }
        };
    }

    private static class AWT {
        private AWT() {
        }

        static long getWindowID(Window w) throws HeadlessException {
            return AWT.getComponentID(w);
        }

        static long getComponentID(Object o) throws HeadlessException {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException("No native windows when headless");
            }
            Component c = (Component)o;
            if (c.isLightweight()) {
                throw new IllegalArgumentException("Component must be heavyweight");
            }
            if (!c.isDisplayable()) {
                throw new IllegalStateException("Component must be displayable");
            }
            if (Platform.isX11() && System.getProperty("java.version").startsWith("1.4") && !c.isVisible()) {
                throw new IllegalStateException("Component must be visible");
            }
            return Native.getWindowHandle0(c);
        }
    }

    private static class Buffers {
        private Buffers() {
        }

        static boolean isBuffer(Class cls) {
            return (class$java$nio$Buffer == null ? (class$java$nio$Buffer = Native.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(cls);
        }
    }

    public static interface ffi_callback {
        public void invoke(long var1, long var3, long var5);
    }
}

