/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.sun.jna;

import org.jetbrains.jet.internal.com.sun.jna.Platform;

public class LastErrorException
extends RuntimeException {
    private int errorCode;

    private static String formatMessage(int code) {
        return Platform.isWindows() ? new StringBuffer().append("GetLastError() returned ").append(code).toString() : new StringBuffer().append("errno was ").append(code).toString();
    }

    private static String parseMessage(String m) {
        try {
            return LastErrorException.formatMessage(Integer.parseInt(m));
        }
        catch (NumberFormatException e) {
            return m;
        }
    }

    public LastErrorException(String msg) {
        super(LastErrorException.parseMessage(msg.trim()));
        try {
            if (msg.startsWith("[")) {
                msg = msg.substring(1, msg.indexOf("]"));
            }
            this.errorCode = Integer.parseInt(msg);
        }
        catch (NumberFormatException e) {
            this.errorCode = -1;
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public LastErrorException(int code) {
        super(LastErrorException.formatMessage(code));
        this.errorCode = code;
    }
}

