/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.xmlb;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.Accessor;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.BeanBinding;

public class XmlSerializerUtil {
    private XmlSerializerUtil() {
    }

    public static <T> void copyBean(@NotNull T from, @NotNull T to) {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xmlb/XmlSerializerUtil.copyBean must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xmlb/XmlSerializerUtil.copyBean must not be null");
        }
        assert (from.getClass().isAssignableFrom(to.getClass())) : "Beans of different classes specified: Cannot assign " + from.getClass() + " to " + to.getClass();
        for (Accessor accessor : BeanBinding.getAccessors(to.getClass())) {
            accessor.write(to, accessor.read(from));
        }
    }

    public static <T> T createCopy(@NotNull T from) {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xmlb/XmlSerializerUtil.createCopy must not be null");
        }
        try {
            Object to = from.getClass().newInstance();
            XmlSerializerUtil.copyBean(from, to);
            return (T)to;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

