/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.xmlb;

import org.jetbrains.jet.internal.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.Binding;
import org.jetbrains.jet.internal.org.jdom.Content;
import org.jetbrains.jet.internal.org.jdom.Element;
import org.jetbrains.jet.internal.org.jdom.Text;

class TagBindingWrapper
implements Binding {
    private final Binding binding;
    private final String myTagName;
    private final String myAttributeName;

    public TagBindingWrapper(Binding binding, String tagName, String attributeName) {
        this.binding = binding;
        assert (binding.getBoundNodeType().isAssignableFrom(Text.class));
        this.myTagName = tagName;
        this.myAttributeName = attributeName;
    }

    @Override
    public Object serialize(Object o, Object context) {
        Element e = new Element(this.myTagName);
        Object n = this.binding.serialize(o, e);
        String value = ((Content)n).getValue();
        if (this.myAttributeName.length() != 0) {
            e.setAttribute(this.myAttributeName, value);
        } else {
            e.addContent(new Text(value));
        }
        return e;
    }

    @Override
    public Object deserialize(Object context, Object ... nodes) {
        assert (nodes.length == 1);
        Element e = (Element)nodes[0];
        Object[] childNodes = this.myAttributeName.length() != 0 ? new Object[]{e.getAttribute(this.myAttributeName)} : JDOMUtil.getContent(e);
        return this.binding.deserialize(context, childNodes);
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    @Override
    public void init() {
    }
}

