/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.xmlb;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.Accessor;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.XmlSerializerImpl;

class PropertyAccessor
implements Accessor {
    private final String myName;
    private final Class<?> myType;
    private final Method myReadMethod;
    private final Method myWriteMethod;
    private final Type myGenericType;

    public PropertyAccessor(PropertyDescriptor descriptor) {
        this(descriptor.getName(), descriptor.getPropertyType(), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    public PropertyAccessor(String name, Class<?> type, Method readMethod, Method writeMethod) {
        this.myName = name;
        this.myType = type;
        this.myReadMethod = readMethod;
        this.myWriteMethod = writeMethod;
        this.myGenericType = this.myReadMethod.getGenericReturnType();
    }

    @Override
    public Object read(Object o) {
        try {
            return this.myReadMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void write(Object o, Object value) {
        try {
            this.myWriteMethod.invoke(o, XmlSerializerImpl.convert(value, this.myType));
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public Annotation[] getAnnotations() {
        ArrayList result = new ArrayList();
        if (this.myReadMethod != null) {
            ContainerUtil.addAll(result, this.myReadMethod.getAnnotations());
        }
        if (this.myWriteMethod != null) {
            ContainerUtil.addAll(result, this.myWriteMethod.getAnnotations());
        }
        return result.toArray(new Annotation[result.size()]);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Class<?> getValueClass() {
        return this.myType;
    }

    @Override
    public Type getGenericType() {
        return this.myGenericType;
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor[" + this.myReadMethod.getDeclaringClass().getName() + "." + this.getName() + "]";
    }
}

