/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.xmlb;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.Binding;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.XmlSerializerImpl;
import org.jetbrains.jet.internal.org.jdom.Text;

class PrimitiveValueBinding
implements Binding {
    private final Class<?> myType;

    public PrimitiveValueBinding(Class<?> myType) {
        this.myType = myType;
    }

    @Override
    public Object serialize(Object o, Object context) {
        return new Text(String.valueOf(o));
    }

    @Override
    @Nullable
    public Object deserialize(Object o, Object ... nodes) {
        String value;
        assert (nodes != null);
        if (nodes.length == 0) {
            return this.convertString("");
        }
        if (nodes.length > 1) {
            value = JDOMUtil.concatTextNodesValues(nodes);
        } else {
            assert (nodes[0] != null);
            value = JDOMUtil.getValue(nodes[0]);
        }
        return this.convertString(value);
    }

    @Nullable
    protected Object convertString(String value) {
        return XmlSerializerImpl.convert(value, this.myType);
    }

    @Override
    public boolean isBoundTo(Object node) {
        throw new UnsupportedOperationException("Method isBoundTo is not supported in " + this.getClass());
    }

    @Override
    public Class getBoundNodeType() {
        return Text.class;
    }

    @Override
    public void init() {
    }
}

