/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.xmlb;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.StreamUtil;
import org.jetbrains.jet.internal.com.intellij.util.io.URLUtil;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.XIncludeException;
import org.jetbrains.jet.internal.org.jdom.Attribute;
import org.jetbrains.jet.internal.org.jdom.Comment;
import org.jetbrains.jet.internal.org.jdom.Content;
import org.jetbrains.jet.internal.org.jdom.Document;
import org.jetbrains.jet.internal.org.jdom.Element;
import org.jetbrains.jet.internal.org.jdom.EntityRef;
import org.jetbrains.jet.internal.org.jdom.JDOMException;
import org.jetbrains.jet.internal.org.jdom.Namespace;
import org.jetbrains.jet.internal.org.jdom.ProcessingInstruction;
import org.jetbrains.jet.internal.org.jdom.Text;

public class JDOMXIncluder {
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace("xi", "http://www.w3.org/2001/XInclude");
    @NonNls
    public static Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static Pattern CHILDREN_PATTERN = Pattern.compile("\\/(.*)\\/\\*");

    private JDOMXIncluder() {
    }

    public static Document resolve(Document original, String base) throws XIncludeException {
        if (original == null) {
            throw new NullPointerException("Document must not be null");
        }
        Document result = (Document)original.clone();
        Element root = result.getRootElement();
        List resolved = JDOMXIncluder.resolve(root, base);
        Element newRoot = null;
        for (Object o : resolved) {
            if (o instanceof Element) {
                if (newRoot != null) {
                    throw new XIncludeException("Tried to include multiple roots");
                }
                newRoot = (Element)o;
                continue;
            }
            if (o instanceof Comment || o instanceof ProcessingInstruction) continue;
            if (o instanceof Text || o instanceof String) {
                throw new XIncludeException("Tried to include text node outside of root element");
            }
            if (o instanceof EntityRef) {
                throw new XIncludeException("Tried to include a general entity reference outside of root element");
            }
            throw new XIncludeException("Unexpected type " + o.getClass());
        }
        if (newRoot == null) {
            throw new XIncludeException("No root element");
        }
        List newContent = result.getContent();
        Iterator iterator = resolved.iterator();
        int rootPosition = newContent.indexOf(result.getRootElement());
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof Comment || o instanceof ProcessingInstruction) {
                newContent.add(rootPosition, o);
                ++rootPosition;
                continue;
            }
            if (!(o instanceof Element)) continue;
            break;
        }
        result.setRootElement(newRoot);
        int addPosition = rootPosition + 1;
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof Comment) && !(o instanceof ProcessingInstruction)) continue;
            newContent.add(addPosition, o);
            ++addPosition;
        }
        return result;
    }

    public static List resolve(@NotNull Element original, String base) throws XIncludeException {
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xmlb/JDOMXIncluder.resolve must not be null");
        }
        Stack<String> bases = new Stack<String>();
        if (base != null) {
            bases.push(base);
        }
        List<Object> result = JDOMXIncluder.resolve(original, bases);
        bases.pop();
        return result;
    }

    private static boolean isIncludeElement(Element element) {
        return element.getName().equals("include") && element.getNamespace().equals(XINCLUDE_NAMESPACE);
    }

    protected static List<Object> resolve(Element original, Stack<String> bases) throws XIncludeException {
        if (bases.size() != 0) {
            bases.peek();
        }
        if (JDOMXIncluder.isIncludeElement(original)) {
            return JDOMXIncluder.resolveXIncludeElement(original, bases);
        }
        Element resolvedElement = JDOMXIncluder.resolveNonXIncludeElement(original, bases);
        ArrayList<Object> resultList = new ArrayList<Object>();
        resultList.add(resolvedElement);
        return resultList;
    }

    private static List<Object> resolveXIncludeElement(Element element, Stack<String> bases) throws XIncludeException {
        URL remote;
        String base = "";
        if (bases.size() != 0) {
            base = bases.peek();
        }
        assert (JDOMXIncluder.isIncludeElement(element));
        String href = element.getAttributeValue("href");
        assert (href != null) : "Missing href attribute";
        Attribute baseAttribute = element.getAttribute("base", Namespace.XML_NAMESPACE);
        if (baseAttribute != null) {
            base = baseAttribute.getValue();
        }
        if (base != null) {
            try {
                URL context = new URL(base);
                remote = new URL(context, href);
            }
            catch (MalformedURLException ex) {
                throw new XIncludeException(ex);
            }
        }
        try {
            remote = new URL(href);
        }
        catch (MalformedURLException ex) {
            throw new XIncludeException(ex);
        }
        boolean parse = true;
        String parseAttribute = element.getAttributeValue("parse");
        if (parseAttribute != null) {
            if (parseAttribute.equals("text")) {
                parse = false;
            }
            assert (parseAttribute.equals("xml")) : parseAttribute + "is not a legal value for the parse attribute";
        }
        if (parse) {
            assert (!bases.contains(remote.toExternalForm())) : "Circular XInclude Reference to " + remote.toExternalForm();
            Element fallbackElement = element.getChild("fallback", element.getNamespace());
            List<Object> remoteParsed = JDOMXIncluder.parseRemote(bases, remote, fallbackElement);
            if (remoteParsed.size() > 0) {
                remoteParsed = JDOMXIncluder.extractNeededChildren(element, remoteParsed);
            }
            for (int i = 0; i < remoteParsed.size(); ++i) {
                Object o = remoteParsed.get(i);
                if (!(o instanceof Element)) continue;
                Element e = (Element)o;
                List<Object> nodes = JDOMXIncluder.resolve(e, bases);
                remoteParsed.addAll(i, nodes);
                remoteParsed.remove(i += nodes.size());
                --i;
                e.detach();
            }
            for (Object o : remoteParsed) {
                if (!(o instanceof Content)) continue;
                Content content = (Content)o;
                content.detach();
            }
            return remoteParsed;
        }
        try {
            String encoding = element.getAttributeValue("encoding");
            String s = StreamUtil.readText(URLUtil.openResourceStream(remote), encoding);
            ArrayList<Object> resultList = new ArrayList<Object>();
            resultList.add(s);
            return resultList;
        }
        catch (IOException e) {
            throw new XIncludeException(e);
        }
    }

    @Nullable
    private static List<Object> extractNeededChildren(Element element, List<Object> remoteElements) {
        String xpointer = element.getAttributeValue("xpointer");
        if (xpointer != null) {
            Matcher matcher = XPOINTER_PATTERN.matcher(xpointer);
            boolean b = matcher.matches();
            assert (b) : "Unsupported XPointer: " + xpointer;
            String pointer = matcher.group(1);
            matcher = CHILDREN_PATTERN.matcher(pointer);
            b = matcher.matches();
            assert (b) : "Unsupported pointer: " + pointer;
            String rootTagName = matcher.group(1);
            assert (remoteElements.size() == 1);
            assert (remoteElements.get(0) instanceof Element);
            Element e = (Element)remoteElements.get(0);
            if (e.getName().equals(rootTagName)) {
                return new ArrayList<Object>(e.getContent());
            }
            return Collections.emptyList();
        }
        return remoteElements;
    }

    private static List<Object> parseRemote(Stack<String> bases, URL remote, @Nullable Element fallbackElement) {
        try {
            Document doc = JDOMUtil.loadResourceDocument(remote);
            bases.push(remote.toExternalForm());
            Element root = doc.getRootElement();
            List<Object> list = JDOMXIncluder.resolve(root, bases);
            bases.pop();
            return list;
        }
        catch (JDOMException e) {
            throw new XIncludeException(e);
        }
        catch (IOException e) {
            if (fallbackElement != null) {
                return Collections.emptyList();
            }
            throw new XIncludeException(e);
        }
    }

    private static Element resolveNonXIncludeElement(Element original, Stack<String> bases) throws XIncludeException {
        if (bases.size() != 0) {
            bases.peek();
        }
        Element result = new Element(original.getName(), original.getNamespace());
        for (Attribute a : original.getAttributes()) {
            result.setAttribute((Attribute)a.clone());
        }
        for (Object o : original.getContent()) {
            if (o instanceof Element) {
                Element element = (Element)o;
                if (JDOMXIncluder.isIncludeElement(element)) {
                    result.addContent(JDOMXIncluder.resolveXIncludeElement(element, bases));
                    continue;
                }
                result.addContent(JDOMXIncluder.resolveNonXIncludeElement(element, bases));
                continue;
            }
            if (o instanceof String) {
                result.addContent((String)o);
                continue;
            }
            if (o instanceof Content) {
                result.addContent((Content)((Content)o).clone());
                continue;
            }
            throw new XIncludeException("Unexpected Type " + o.getClass());
        }
        return result;
    }
}

