/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.xmlb;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.Accessor;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.Binding;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.XmlSerializerImpl;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.jet.internal.org.jdom.Content;
import org.jetbrains.jet.internal.org.jdom.Text;

public class AttributeBinding
implements Binding {
    private final Accessor myAccessor;
    private final Attribute myAttribute;
    private final XmlSerializerImpl myXmlSerializer;
    private Binding myBinding;

    public AttributeBinding(Accessor accessor, Attribute attribute, XmlSerializerImpl xmlSerializer) {
        this.myAccessor = accessor;
        this.myAttribute = attribute;
        this.myXmlSerializer = xmlSerializer;
    }

    @Override
    public Object serialize(Object o, Object context) {
        Object v = this.myAccessor.read(o);
        Object node = this.myBinding.serialize(v, context);
        return new org.jetbrains.jet.internal.org.jdom.Attribute(this.myAttribute.value(), ((Content)node).getValue());
    }

    @Override
    @Nullable
    public Object deserialize(Object context, Object ... nodes) {
        assert (nodes.length == 1);
        Object node = nodes[0];
        assert (this.isBoundTo(node));
        org.jetbrains.jet.internal.org.jdom.Attribute attr = (org.jetbrains.jet.internal.org.jdom.Attribute)node;
        String value = attr.getValue();
        Text text = new Text(value);
        this.myAccessor.write(context, this.myBinding.deserialize(context, text));
        return context;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof org.jetbrains.jet.internal.org.jdom.Attribute && ((org.jetbrains.jet.internal.org.jdom.Attribute)node).getName().equals(this.myAttribute.value());
    }

    @Override
    public Class getBoundNodeType() {
        return org.jetbrains.jet.internal.org.jdom.Attribute.class;
    }

    @Override
    public void init() {
        this.myBinding = this.myXmlSerializer.getBinding(this.myAccessor);
        if (!Text.class.isAssignableFrom(this.myBinding.getBoundNodeType())) {
            throw new XmlSerializationException("Can't use attribute binding for non-text content: " + this.myAccessor);
        }
    }
}

