/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.ui;

import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public class RadioButtonEnumModel<E extends Enum<E>> {
    private final ButtonGroup myGroup;
    private final List<ButtonModel> myModels;
    private final List<E> myEnums;

    public static <E extends Enum<E>> RadioButtonEnumModel<E> bindEnum(Class<E> e, ButtonGroup group) {
        return new RadioButtonEnumModel<E>(e, group);
    }

    private RadioButtonEnumModel(Class<E> e, ButtonGroup group) {
        this.myGroup = group;
        this.myModels = ContainerUtil.map(Collections.list(this.myGroup.getElements()), new Function<AbstractButton, ButtonModel>(){

            @Override
            public ButtonModel fun(AbstractButton abstractButton) {
                return abstractButton.getModel();
            }
        });
        this.myEnums = Arrays.asList(e.getEnumConstants());
    }

    public E getSelected() {
        ButtonModel selection = this.myGroup.getSelection();
        int i = this.myModels.indexOf(selection);
        return (E)((Enum)this.myEnums.get(i));
    }

    public void setSelected(E e) {
        int i = this.myEnums.indexOf(e);
        this.myGroup.setSelected(this.myModels.get(i), true);
    }

    public void addActionListener(ActionListener listener) {
        for (AbstractButton button : Collections.list(this.myGroup.getElements())) {
            button.addActionListener(listener);
        }
    }
}

