/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.ui;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;

public class MappingListCellRenderer
extends DefaultListCellRenderer {
    private final Map<Object, String> myValueMap;

    public MappingListCellRenderer(Map<Object, String> valueMap) {
        this.myValueMap = valueMap;
    }

    public MappingListCellRenderer(Pair<Object, String> ... valuePairs) {
        this.myValueMap = new HashMap<Object, String>();
        for (Pair<Object, String> valuePair : valuePairs) {
            this.myValueMap.put(valuePair.getFirst(), valuePair.getSecond());
        }
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String newValue = this.myValueMap.get(value);
        if (newValue != null) {
            this.setText(newValue);
        }
        return this;
    }
}

