/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.ui;

import java.awt.FontMetrics;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.jet.internal.com.intellij.util.ui.SplitByLetterPolicy;
import org.jetbrains.jet.internal.com.intellij.util.ui.SplitBySeparatorPolicy;

public abstract class FilePathSplittingPolicy {
    public static final FilePathSplittingPolicy SPLIT_BY_LETTER = new SplitByLetterPolicy();
    public static final FilePathSplittingPolicy SPLIT_BY_SEPARATOR = new SplitBySeparatorPolicy();

    public abstract String getPresentableName(File var1, int var2);

    public String getOptimalTextForComponent(String staticPrefix, File file, JComponent component, int width) {
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        String path = file.getPath();
        for (int i = 1; i <= path.length(); ++i) {
            String text = this.getPresentableName(file, i);
            if (fontMetrics.stringWidth(staticPrefix + text) <= width) continue;
            if (i == 1) {
                return text;
            }
            return this.getPresentableName(file, i - 1);
        }
        return path;
    }

    public String getOptimalTextForComponent(File file, JComponent component, int width) {
        return this.getOptimalTextForComponent("", file, component, width);
    }

    public String getOptimalTextForComponent(File file, JComponent component) {
        return this.getOptimalTextForComponent(file, component, component.getWidth());
    }
}

