/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.jet.internal.com.intellij.ui.Gray;

public class BlockBorder
implements Border {
    private static final Insets DEFAULT_INSETS = new Insets(1, 1, 3, 3);
    private static final Color DEFAULT_SHADE1 = Gray._203;
    private static final Color DEFAULT_SHADE2 = Gray._238;
    private static final Insets EMPTY = new Insets(0, 0, 0, 0);
    private Insets myInsets;
    private Insets myOuterMargin;
    private Color myBoundsColor = Color.GRAY;
    private Color myShade1;
    private Color myShade2;

    public BlockBorder() {
        this(null, null, DEFAULT_SHADE1, DEFAULT_SHADE2);
    }

    public BlockBorder(Insets outerMargin, Insets innerMargin) {
        this(outerMargin, innerMargin, DEFAULT_SHADE1, DEFAULT_SHADE2);
    }

    public BlockBorder(Insets outerMargin, Insets innerMargin, Color aShade1, Color aShade2) {
        if (outerMargin == null) {
            outerMargin = EMPTY;
        }
        this.myOuterMargin = (Insets)outerMargin.clone();
        this.myInsets = (Insets)outerMargin.clone();
        this.myInsets.top += BlockBorder.DEFAULT_INSETS.top;
        this.myInsets.left += BlockBorder.DEFAULT_INSETS.left;
        this.myInsets.bottom += BlockBorder.DEFAULT_INSETS.bottom;
        this.myInsets.right += BlockBorder.DEFAULT_INSETS.right;
        if (innerMargin == null) {
            innerMargin = EMPTY;
        }
        this.myInsets.top += innerMargin.top;
        this.myInsets.left += innerMargin.left;
        this.myInsets.bottom += innerMargin.bottom;
        this.myInsets.right += innerMargin.right;
        this.myShade1 = aShade1;
        this.myShade2 = aShade2;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.getBoundsColor());
        int horMargin = this.myOuterMargin.left + this.myOuterMargin.right;
        int vertMargin = this.myOuterMargin.top + this.myOuterMargin.bottom;
        g2.drawRect(x + this.myOuterMargin.left, y + this.myOuterMargin.top, x + width - 3 - horMargin, y + height - 3 - vertMargin);
        g2.setPaint(this.myShade1);
        g2.drawLine(x + 1 + this.myOuterMargin.left, y + height - 2 - this.myOuterMargin.bottom, x + width - 2 - this.myOuterMargin.right, y + height - 2 - this.myOuterMargin.bottom);
        g2.drawLine(x + width - 2 - this.myOuterMargin.right, y + 1 + this.myOuterMargin.bottom, x + width - 2 - this.myOuterMargin.right, y + height - 2 - this.myOuterMargin.bottom);
        g2.setPaint(this.myShade2);
        g2.drawLine(x + 2 + this.myOuterMargin.left, y + height - 1 - this.myOuterMargin.bottom, x + width - 1 - this.myOuterMargin.right, y + height - 1 - this.myOuterMargin.bottom);
        g2.drawLine(x + width - 1 - this.myOuterMargin.right, y + 2 + this.myOuterMargin.top, x + width - 1 - this.myOuterMargin.right, y + height - 1 - this.myOuterMargin.bottom);
    }

    private Color getBoundsColor() {
        return this.myBoundsColor;
    }

    public void setBoundsColor(Color aColor) {
        this.myBoundsColor = aColor;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.myInsets;
    }

    public static void main(String[] args) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().setBackground(Color.white);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.white);
        jPanel.setOpaque(true);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), new BlockBorder(new Insets(5, 5, 5, 5), new Insets(5, 5, 5, 5))));
        jFrame.getContentPane().add(jPanel);
        jFrame.setBounds(100, 100, 200, 200);
        jFrame.setVisible(true);
    }
}

