/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.text;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.CommonBundle;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Clock;
import org.jetbrains.jet.internal.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.jet.internal.com.intellij.ui.mac.foundation.Foundation;
import org.jetbrains.jet.internal.com.intellij.ui.mac.foundation.ID;
import org.jetbrains.jet.internal.com.intellij.util.text.SyncDateFormat;

public class DateFormatUtil {
    private static final Logger LOG = Logger.getInstance("org.jetbrains.jet.internal.com.intellij.util.text.DateFormatUtil");
    private static final SyncDateFormat DATE_FORMAT = DateFormatUtil.getFormat(3, DateType.DATE);
    private static final SyncDateFormat TIME_FORMAT = DateFormatUtil.getFormat(3, DateType.TIME);
    private static final SyncDateFormat TIME_WITH_SECONDS_FORMAT = DateFormatUtil.getFormat(2, DateType.TIME);
    private static final SyncDateFormat DATE_TIME_FORMAT = DateFormatUtil.getFormat(3, DateType.DATETIME);
    private static final SimpleDateFormat BUILD_DATE_FORMAT = new SimpleDateFormat("dd MMM yyyy HH:ss", Locale.US);
    private static final DateFormat ABOUT_DATE_FORMAT = DateFormat.getDateInstance(1, Locale.US);
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31536000000L;
    private static final long[] DELIMS = new long[]{31536000000L, 2592000000L, 604800000L, 86400000L, 3600000L, 60000L};
    private static final Period[] PERIOD = new Period[]{Period.YEAR, Period.MONTH, Period.WEEK, Period.DAY, Period.HOUR, Period.MINUTE};

    private static SyncDateFormat getFormat(int format, DateType type) {
        DateFormat result = null;
        if (SystemInfo.isMac) {
            try {
                result = new SimpleDateFormat(DateFormatUtil.getMacTimeFormat(format, type).trim());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (result == null) {
            switch (type) {
                case TIME: {
                    result = DateFormat.getTimeInstance(format);
                    break;
                }
                case DATE: {
                    result = DateFormat.getDateInstance(format);
                    break;
                }
                case DATETIME: {
                    result = DateFormat.getDateTimeInstance(format, format);
                }
            }
        }
        return new SyncDateFormat(result);
    }

    private DateFormatUtil() {
    }

    @NotNull
    public static SyncDateFormat getDateFormat() {
        SyncDateFormat syncDateFormat = DATE_FORMAT;
        if (syncDateFormat == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.getDateFormat must not return null");
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getTimeFormat() {
        SyncDateFormat syncDateFormat = TIME_FORMAT;
        if (syncDateFormat == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.getTimeFormat must not return null");
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getTimeWithSecondsFormat() {
        SyncDateFormat syncDateFormat = TIME_WITH_SECONDS_FORMAT;
        if (syncDateFormat == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.getTimeWithSecondsFormat must not return null");
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getDateTimeFormat() {
        SyncDateFormat syncDateFormat = DATE_TIME_FORMAT;
        if (syncDateFormat == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.getDateTimeFormat must not return null");
        }
        return syncDateFormat;
    }

    @NotNull
    public static String formatTime(@NotNull Date time) {
        if (time == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/DateFormatUtil.formatTime must not be null");
        }
        String string = DateFormatUtil.formatTime(time.getTime());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatTime must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatTime(long time) {
        String string = DateFormatUtil.getTimeFormat().format(time);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatTime must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatTimeWithSeconds(@NotNull Date time) {
        if (time == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/DateFormatUtil.formatTimeWithSeconds must not be null");
        }
        String string = DateFormatUtil.formatTimeWithSeconds(time.getTime());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatTimeWithSeconds must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatTimeWithSeconds(long time) {
        String string = DateFormatUtil.getTimeWithSecondsFormat().format(time);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatTimeWithSeconds must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatDate(@NotNull Date time) {
        if (time == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/DateFormatUtil.formatDate must not be null");
        }
        String string = DateFormatUtil.formatDate(time.getTime());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatDate must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatDate(long time) {
        String string = DateFormatUtil.getDateFormat().format(time);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatDate must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDate(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/DateFormatUtil.formatPrettyDate must not be null");
        }
        String string = DateFormatUtil.formatPrettyDate(date.getTime());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatPrettyDate must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDate(long time) {
        String string = DateFormatUtil.doFormatPretty(time, false);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatPrettyDate must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatDateTime(Date date) {
        String string = DateFormatUtil.formatDateTime(date.getTime());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatDateTime must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatDateTime(long time) {
        String string = DateFormatUtil.getDateTimeFormat().format(time);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatDateTime must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDateTime(Date date) {
        String string = DateFormatUtil.formatPrettyDateTime(date.getTime());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatPrettyDateTime must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDateTime(long time) {
        String string = DateFormatUtil.doFormatPretty(time, true);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatPrettyDateTime must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String doFormatPretty(long time, boolean formatTime) {
        boolean isYesterday;
        boolean isToday;
        String string;
        long delta;
        long currentTime = Clock.getTime();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(currentTime);
        int currentYear = c.get(1);
        int currentDayOfYear = c.get(6);
        c.setTimeInMillis(time);
        int year = c.get(1);
        int dayOfYear = c.get(6);
        if (formatTime && (delta = currentTime - time) <= 3600000L) {
            string = CommonBundle.message("date.format.minutes.ago", (int)Math.rint((double)delta / 60000.0));
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.doFormatPretty must not return null");
            return string;
        }
        boolean bl = isToday = currentYear == year && currentDayOfYear == dayOfYear;
        if (isToday) {
            String result = CommonBundle.message("date.format.today", new Object[0]);
            if (formatTime) {
                result = result + " " + TIME_FORMAT.format(time);
            }
            if ((string = result) == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.doFormatPretty must not return null");
            return string;
        }
        boolean isYesterdayOnPreviousYear = currentYear == year + 1 && currentDayOfYear == 1 && dayOfYear == c.getActualMaximum(6);
        boolean bl2 = isYesterday = isYesterdayOnPreviousYear || currentYear == year && currentDayOfYear == dayOfYear + 1;
        if (isYesterday) {
            String result = CommonBundle.message("date.format.yesterday", new Object[0]);
            if (formatTime) {
                result = result + " " + TIME_FORMAT.format(time);
            }
            if ((string = result) == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.doFormatPretty must not return null");
            return string;
        }
        string = formatTime ? DATE_TIME_FORMAT.format(time) : DATE_FORMAT.format(time);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.doFormatPretty must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String formatDuration(long delta) {
        String string;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < DELIMS.length; ++i) {
            long delim = DELIMS[i];
            int n = (int)(delta / delim);
            if (n == 0) continue;
            buf.append(DateFormatUtil.composeDurationMessage(PERIOD[i], n));
            buf.append(' ');
            delta %= delim;
        }
        if (buf.length() == 0) {
            string = CommonBundle.message("date.format.less.than.a.minute", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatDuration must not return null");
            return string;
        }
        string = buf.toString().trim();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatDuration must not return null");
    }

    private static String composeDurationMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.n.days", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.n.minutes", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.n.hours", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.n.months", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.n.weeks", n);
            }
        }
        return CommonBundle.message("date.format.n.years", n);
    }

    @NotNull
    public static String formatFrequency(long time) {
        String string = CommonBundle.message("date.frequency", DateFormatUtil.formatBetweenDates(time, 0L));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatFrequency must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String formatBetweenDates(long d1, long d2) {
        int i;
        String string;
        long delta = Math.abs(d1 - d2);
        if (delta == 0L) {
            String string2 = CommonBundle.message("date.format.right.now", new Object[0]);
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatBetweenDates must not return null");
        }
        int n = -1;
        for (i = 0; i < DELIMS.length; ++i) {
            long delim = DELIMS[i];
            if (delta < delim) continue;
            n = (int)(delta / delim);
            break;
        }
        if (d2 > d1) {
            if (n <= 0) {
                String string3 = CommonBundle.message("date.format.a.few.moments.ago", new Object[0]);
                string = string3;
                if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatBetweenDates must not return null");
                return string;
            }
            String string4 = DateFormatUtil.someTimeAgoMessage(PERIOD[i], n);
            string = string4;
            if (string4 == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatBetweenDates must not return null");
            return string;
        }
        if (d2 >= d1) return "";
        if (n <= 0) {
            String string5 = CommonBundle.message("date.format.in.a.few.moments", new Object[0]);
            string = string5;
            if (string5 == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatBetweenDates must not return null");
            return string;
        }
        String string6 = DateFormatUtil.composeInSomeTimeMessage(PERIOD[i], n);
        string = string6;
        if (string6 == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatBetweenDates must not return null");
        return string;
    }

    private static String someTimeAgoMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.n.days.ago", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.n.minutes.ago", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.n.hours.ago", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.n.months.ago", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.n.weeks.ago", n);
            }
        }
        return CommonBundle.message("date.format.n.years.ago", n);
    }

    private static String composeInSomeTimeMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.in.n.days", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.in.n.minutes", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.in.n.hours", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.in.n.months", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.in.n.weeks", n);
            }
        }
        return CommonBundle.message("date.format.in.n.years", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static String getMacTimeFormat(int type, @NotNull DateType dateType) {
        int dateStyle;
        int timeStyle;
        int style;
        if (dateType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/text/DateFormatUtil.getMacTimeFormat must not be null");
        }
        ID autoReleasePool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
        ID dateFormatter = Foundation.invoke("NSDateFormatter", "new", new Object[0]);
        Foundation.invoke(dateFormatter, Foundation.createSelector("setFormatterBehavior:"), 1040);
        switch (type) {
            case 3: {
                style = 1;
                break;
            }
            case 2: {
                style = 2;
                break;
            }
            case 1: {
                style = 3;
                break;
            }
            default: {
                style = 4;
            }
        }
        switch (dateType) {
            case DATE: {
                timeStyle = 0;
                dateStyle = style;
                break;
            }
            case TIME: {
                timeStyle = style;
                dateStyle = 0;
                break;
            }
            default: {
                timeStyle = style;
                dateStyle = style;
            }
        }
        Foundation.invoke(dateFormatter, Foundation.createSelector("setTimeStyle:"), timeStyle);
        Foundation.invoke(dateFormatter, Foundation.createSelector("setDateStyle:"), dateStyle);
        String string = Foundation.toStringViaUTF8(Foundation.invoke(dateFormatter, Foundation.createSelector("dateFormat"), new Object[0]));
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.getMacTimeFormat must not return null");
        }
        return string2;
        finally {
            Foundation.invoke(autoReleasePool, Foundation.createSelector("release"), new Object[0]);
        }
    }

    @NotNull
    public static String formatBuildDate(@NotNull Calendar cal) {
        if (cal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/DateFormatUtil.formatBuildDate must not be null");
        }
        String string = BUILD_DATE_FORMAT.format(cal.getTime());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatBuildDate must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatAboutDialogDate(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/DateFormatUtil.formatAboutDialogDate must not be null");
        }
        String string = ABOUT_DATE_FORMAT.format(date);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/DateFormatUtil.formatAboutDialogDate must not return null");
        }
        return string;
    }

    private static enum DateType {
        TIME,
        DATE,
        DATETIME;

    }

    private static enum Period {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE;

    }
}

