/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.text;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.util.text.CharSequenceBackedByArray;

public class CharArrayCharSequence
implements CharSequenceBackedByArray {
    private final char[] myChars;
    private final int myStart;
    private final int myEnd;

    public CharArrayCharSequence(char ... chars) {
        this(chars, 0, chars.length);
    }

    public CharArrayCharSequence(char[] chars, int start, int end) {
        if (start < 0 || end > chars.length || start > end) {
            throw new IndexOutOfBoundsException("chars.length:" + chars.length + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars[index + this.myStart];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new CharArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    public String toString() {
        return new String(this.myChars, this.myStart, this.myEnd - this.myStart);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public char[] getChars() {
        char[] cArray;
        if (this.myStart == 0) {
            cArray = this.myChars;
            if (this.myChars == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayCharSequence.getChars must not return null");
            return cArray;
        }
        char[] chars = new char[this.length()];
        System.arraycopy(this.myChars, this.myStart, chars, 0, this.length());
        cArray = chars;
        if (chars != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayCharSequence.getChars must not return null");
    }

    public int hashCode() {
        return StringUtil.stringHashCode(this.myChars, this.myStart, this.myEnd);
    }

    @Override
    public void getChars(@NotNull char[] dst, int dstOffset) {
        if (dst == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayCharSequence.getChars must not be null");
        }
        System.arraycopy(this.myChars, this.myStart, dst, dstOffset, this.length());
    }

    public boolean equals(Object anObject) {
        CharSequence anotherString;
        int n;
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof CharSequence && (n = this.myEnd - this.myStart) == (anotherString = (CharSequence)anObject).length()) {
            for (int i = 0; i < n; ++i) {
                if (this.myChars[this.myStart + i] == anotherString.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int readCharsTo(int start, char[] cbuf, int off, int len) {
        int readChars = Math.min(len, this.length() - start);
        if (readChars <= 0) {
            return -1;
        }
        System.arraycopy(this.myChars, start, cbuf, off, readChars);
        return readChars;
    }
}

