/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.pico;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.ReflectionCache;
import org.jetbrains.jet.internal.com.intellij.util.pico.AssignableToComponentAdapter;
import org.jetbrains.jet.internal.com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.ComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.ComponentMonitor;
import org.jetbrains.jet.internal.org.picocontainer.Parameter;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.CachingComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ComponentMonitorStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.LifecycleStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.MonitoringComponentAdapterFactory;
import org.jetbrains.jet.internal.org.picocontainer.defaults.NotConcreteRegistrationException;
import org.jetbrains.jet.internal.org.picocontainer.monitors.DefaultComponentMonitor;

public class IdeaPicoContainer
extends DefaultPicoContainer {
    public IdeaPicoContainer() {
        this(null);
    }

    public IdeaPicoContainer(PicoContainer parent) {
        super(new MyComponentAdapterFactory(), parent);
    }

    @Override
    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        return super.getComponentAdapterOfType(componentType);
    }

    @Override
    public List getComponentAdaptersOfType(Class componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        if (componentType == String.class) {
            return Collections.emptyList();
        }
        ArrayList<ComponentAdapter> result = new ArrayList<ComponentAdapter>();
        Map<String, ComponentAdapter> cache = this.getAssignablesCache();
        ComponentAdapter cacheHit = cache.get(componentType.getName());
        if (cacheHit != null) {
            result.add(cacheHit);
        }
        for (ComponentAdapter o : this.getNonAssignableAdapters()) {
            ComponentAdapter componentAdapter = o;
            if (componentAdapter instanceof AssignableToComponentAdapter) {
                AssignableToComponentAdapter assignableToComponentAdapter = (AssignableToComponentAdapter)componentAdapter;
                if (!assignableToComponentAdapter.isAssignableTo(componentType)) continue;
                result.add(assignableToComponentAdapter);
                continue;
            }
            if (!ReflectionCache.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            result.add(componentAdapter);
        }
        return result;
    }

    private static class MyComponentAdapterFactory
    extends MonitoringComponentAdapterFactory {
        private final LifecycleStrategy myLifecycleStrategy = new DefaultLifecycleStrategy(new DefaultComponentMonitor());

        private MyComponentAdapterFactory() {
        }

        @Override
        public ComponentAdapter createComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
            if (componentKey == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/pico/IdeaPicoContainer$MyComponentAdapterFactory.createComponentAdapter must not be null");
            }
            if (componentImplementation == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/pico/IdeaPicoContainer$MyComponentAdapterFactory.createComponentAdapter must not be null");
            }
            return new CachingComponentAdapter(new ConstructorInjectionComponentAdapter(componentKey, componentImplementation, parameters, true, this.currentMonitor(), this.myLifecycleStrategy));
        }

        @Override
        public void changeMonitor(ComponentMonitor monitor) {
            super.changeMonitor(monitor);
            if (this.myLifecycleStrategy instanceof ComponentMonitorStrategy) {
                ((ComponentMonitorStrategy)((Object)this.myLifecycleStrategy)).changeMonitor(monitor);
            }
        }
    }
}

