/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.messages.impl;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBus;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.jet.internal.com.intellij.util.messages.Topic;

public class MessageListenerList<T> {
    private final MessageBus myMessageBus;
    private final Topic<T> myTopic;
    private final Map<T, MessageBusConnection> myListenerToConnectionMap;

    public MessageListenerList(@NotNull MessageBus messageBus, @NotNull Topic<T> topic) {
        if (messageBus == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/impl/MessageListenerList.<init> must not be null");
        }
        if (topic == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/messages/impl/MessageListenerList.<init> must not be null");
        }
        this.myListenerToConnectionMap = new HashMap<T, MessageBusConnection>();
        this.myTopic = topic;
        this.myMessageBus = messageBus;
    }

    public void add(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/impl/MessageListenerList.add must not be null");
        }
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(this.myTopic, listener);
        this.myListenerToConnectionMap.put(listener, connection);
    }

    public void add(final @NotNull T listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/impl/MessageListenerList.add must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/messages/impl/MessageListenerList.add must not be null");
        }
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                MessageListenerList.this.myListenerToConnectionMap.remove(listener);
            }
        });
        MessageBusConnection connection = this.myMessageBus.connect(parentDisposable);
        connection.subscribe(this.myTopic, listener);
        this.myListenerToConnectionMap.put(listener, connection);
    }

    public void remove(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/impl/MessageListenerList.remove must not be null");
        }
        MessageBusConnection connection = this.myListenerToConnectionMap.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }
}

