/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.messages.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBus;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.jet.internal.com.intellij.util.messages.Topic;
import org.jetbrains.jet.internal.com.intellij.util.messages.impl.Message;
import org.jetbrains.jet.internal.com.intellij.util.messages.impl.MessageBusConnectionImpl;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusImpl");
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue = new ThreadLocal<Queue<DeliveryJob>>(){

        @Override
        protected Queue<DeliveryJob> initialValue() {
            return new ConcurrentLinkedQueue<DeliveryJob>();
        }
    };
    private final ConcurrentMap<Topic, Object> mySyncPublishers = new ConcurrentHashMap<Topic, Object>();
    private final ConcurrentMap<Topic, Object> myAsyncPublishers = new ConcurrentHashMap<Topic, Object>();
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers = new ConcurrentHashMap<Topic, List<MessageBusConnectionImpl>>();
    private final List<MessageBusImpl> myChildBuses = ContainerUtil.createEmptyCOWList();
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    private final Object myOwner;
    private boolean myDisposed;

    public MessageBusImpl() {
        this(null, null);
    }

    public MessageBusImpl(Object owner, MessageBus parentBus) {
        this.myOwner = owner == null ? null : owner.toString();
        this.myParentBus = (MessageBusImpl)parentBus;
        if (this.myParentBus != null) {
            this.myParentBus.notifyChildBusCreated(this);
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
        }
    }

    @Override
    public MessageBus getParent() {
        return this.myParentBus;
    }

    private void notifyChildBusCreated(MessageBusImpl childBus) {
        this.myChildBuses.add(childBus);
        LOG.assertTrue(childBus.myParentBus == this);
    }

    private void notifyChildBusDisposed(MessageBusImpl childBus) {
        boolean removed = this.myChildBuses.remove(childBus);
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        this.checkNotDisposed();
        MessageBusConnectionImpl messageBusConnectionImpl = new MessageBusConnectionImpl(this);
        if (messageBusConnectionImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/messages/impl/MessageBusImpl.connect must not return null");
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/impl/MessageBusImpl.connect must not be null");
        }
        MessageBusConnection connection = this.connect();
        Disposer.register(parentDisposable, connection);
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/messages/impl/MessageBusImpl.connect must not return null");
        }
        return messageBusConnection;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(final @NotNull Topic<L> topic) {
        if (topic == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/impl/MessageBusImpl.syncPublisher must not be null");
        }
        this.checkNotDisposed();
        Object publisher = this.mySyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.sendMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.mySyncPublishers, topic, publisher);
        }
        Object v = publisher;
        if (v == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/messages/impl/MessageBusImpl.syncPublisher must not return null");
        }
        return (L)v;
    }

    @Override
    @NotNull
    public <L> L asyncPublisher(final @NotNull Topic<L> topic) {
        if (topic == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/impl/MessageBusImpl.asyncPublisher must not be null");
        }
        this.checkNotDisposed();
        Object publisher = this.myAsyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.postMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.myAsyncPublishers, topic, publisher);
        }
        Object v = publisher;
        if (v == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/messages/impl/MessageBusImpl.asyncPublisher must not return null");
        }
        return (L)v;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.notifyChildBusDisposed(this);
            this.myParentBus = null;
        }
        this.myDisposed = true;
    }

    private void checkNotDisposed() {
        LOG.assertTrue(!this.myDisposed, "Already disposed");
    }

    private void postMessage(Message message) {
        Topic.BroadcastDirection direction;
        this.checkNotDisposed();
        Topic topic = message.getTopic();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers != null) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                this.myMessageQueue.get().offer(new DeliveryJob(subscriber, message));
                subscriber.scheduleMessageDelivery(message);
            }
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.postMessage(message);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.postMessage(message);
        }
    }

    private void sendMessage(Message message) {
        this.pumpMessages();
        this.postMessage(message);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        if (this.myParentBus != null) {
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
            this.myParentBus.pumpMessages();
        } else {
            this.doPumpMessages();
        }
    }

    private void doPumpMessages() {
        DeliveryJob job;
        while ((job = this.myMessageQueue.get().poll()) != null) {
            job.connection.deliverMessage(job.message);
        }
        for (MessageBusImpl childBus : this.myChildBuses) {
            LOG.assertTrue(childBus.myParentBus == this);
            childBus.doPumpMessages();
        }
    }

    public void notifyOnSubscription(MessageBusConnectionImpl connection, Topic topic) {
        this.checkNotDisposed();
        List<Object> topicSubscribers = (CopyOnWriteArrayList)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createEmptyCOWList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
    }

    public void notifyConnectionTerminated(MessageBusConnectionImpl connection) {
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
        }
    }

    public void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        job.connection.deliverMessage(job.message);
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        public DeliveryJob(MessageBusConnectionImpl connection, Message message) {
            this.connection = connection;
            this.message = message;
        }

        public String toString() {
            return "{ DJob connection:" + this.connection.toString() + "; message: " + this.message + " }";
        }
    }
}

