/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.messages.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageHandler;
import org.jetbrains.jet.internal.com.intellij.util.messages.Topic;
import org.jetbrains.jet.internal.com.intellij.util.messages.impl.Message;
import org.jetbrains.jet.internal.com.intellij.util.messages.impl.MessageBusImpl;

public class MessageBusConnectionImpl
implements MessageBusConnection {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusConnectionImpl");
    private final MessageBusImpl myBus;
    private final ThreadLocal<Queue<Message>> myPendingMessages = new ThreadLocal<Queue<Message>>(){

        @Override
        protected Queue<Message> initialValue() {
            return new ConcurrentLinkedQueue<Message>();
        }
    };
    private MessageHandler myDefaultHandler;
    private final Map<Topic, Object> mySubscriptions = new HashMap<Topic, Object>();

    public MessageBusConnectionImpl(MessageBusImpl bus) {
        this.myBus = bus;
    }

    @Override
    public <L> void subscribe(Topic<L> topic, L handler) throws IllegalStateException {
        if (this.mySubscriptions.put(topic, handler) != null) {
            throw new IllegalStateException("Subscription to " + topic + " already exists");
        }
        this.myBus.notifyOnSubscription(this, topic);
    }

    @Override
    public <L> void subscribe(Topic<L> topic) throws IllegalStateException {
        if (this.myDefaultHandler == null) {
            throw new IllegalStateException("Connection must have default handler installed prior to any anonymous subscriptions. Target topic: " + topic);
        }
        if (topic.getListenerClass().isInstance(this.myDefaultHandler)) {
            throw new IllegalStateException(String.format("Can't subscribe to the topic '%s'. Reason: default handler has incompatible type - expected: '%s', actual: '%s'", topic, topic.getListenerClass(), this.myDefaultHandler.getClass()));
        }
        this.subscribe(topic, this.myDefaultHandler);
    }

    @Override
    public void setDefaultHandler(MessageHandler handler) {
        this.myDefaultHandler = handler;
    }

    @Override
    public void disconnect() {
        Queue<Message> jobs = this.myPendingMessages.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myPendingMessages.remove();
        this.myBus.notifyConnectionTerminated(this);
    }

    @Override
    public void dispose() {
        this.disconnect();
    }

    @Override
    public void deliverImmediately() {
        while (!this.myPendingMessages.get().isEmpty()) {
            this.myBus.deliverSingleMessage();
        }
    }

    void deliverMessage(Message message) {
        Message messageOnLocalQueue = this.myPendingMessages.get().poll();
        assert (messageOnLocalQueue == message);
        Topic topic = message.getTopic();
        Object handler = this.mySubscriptions.get(topic);
        try {
            Method listenerMethod = message.getListenerMethod();
            if (handler == this.myDefaultHandler) {
                this.myDefaultHandler.handle(listenerMethod, message.getArgs());
            } else {
                listenerMethod.invoke(handler, message.getArgs());
            }
        }
        catch (AbstractMethodError listenerMethod) {
        }
        catch (Throwable e) {
            LOG.error(e.getCause());
        }
    }

    void scheduleMessageDelivery(Message message) {
        this.myPendingMessages.get().offer(message);
    }

    public String toString() {
        return this.mySubscriptions.keySet().toString();
    }
}

