/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.messages.impl;

import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.messages.Topic;

public final class Message {
    private final Topic myTopic;
    private final Method myListenerMethod;
    private final Object[] myArgs;

    public Message(@NotNull Topic topic, @NotNull Method listenerMethod, Object[] args) {
        if (topic == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/impl/Message.<init> must not be null");
        }
        if (listenerMethod == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/messages/impl/Message.<init> must not be null");
        }
        this.myTopic = topic;
        listenerMethod.setAccessible(true);
        this.myListenerMethod = listenerMethod;
        this.myArgs = args;
    }

    @NotNull
    public Topic getTopic() {
        Topic topic = this.myTopic;
        if (topic == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/messages/impl/Message.getTopic must not return null");
        }
        return topic;
    }

    @NotNull
    public Method getListenerMethod() {
        Method method = this.myListenerMethod;
        if (method == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/messages/impl/Message.getListenerMethod must not return null");
        }
        return method;
    }

    public Object[] getArgs() {
        return this.myArgs;
    }

    public String toString() {
        return this.myTopic.toString() + ":" + this.myListenerMethod.getName();
    }
}

