/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.lang;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringHash;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.BloomFilterBase;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;
import org.jetbrains.jet.internal.com.intellij.util.lang.Loader;
import org.jetbrains.jet.internal.com.intellij.util.lang.UrlClassLoader;
import org.jetbrains.jet.internal.gnu.trove.THashMap;
import org.jetbrains.jet.internal.gnu.trove.THashSet;
import org.jetbrains.jet.internal.gnu.trove.TIntHashSet;
import org.jetbrains.jet.internal.gnu.trove.TIntObjectHashMap;

public class ClasspathCache {
    private final DebugInfo myDebugInfo = null;
    private final TIntObjectHashMap<Object> myResourcePackagesCache = new TIntObjectHashMap();
    private final TIntObjectHashMap<Object> myClassPackagesCache = new TIntObjectHashMap();
    private THashMap<String, Set<Loader>> myResources2LoadersTempMap = new THashMap();
    private Name2LoaderFilter myNameFilter;
    private boolean myTempMapMode = true;
    private int registeredBeforeClose;
    private int registeredAfterClose;
    private static int hits;
    private static int requests;
    private static int requests2;
    private static int hits2;

    public void addResourceEntry(String resourcePath, Loader loader) {
        int hash;
        String packageName = ClasspathCache.getPackageName(resourcePath);
        TIntObjectHashMap<Object> map = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
        Object o = map.get(hash = packageName.hashCode());
        if (o == null) {
            map.put(hash, loader);
        } else if (o instanceof Loader) {
            if (o != loader) {
                map.put(hash, new Loader[]{(Loader)o, loader});
            }
        } else {
            Loader[] loadersArray;
            for (Loader l : loadersArray = (Loader[])o) {
                if (l != loader) continue;
                return;
            }
            map.put(hash, ArrayUtil.append(loadersArray, loader));
        }
    }

    @Nullable
    <ResultType, ParameterType, ParameterType2> ResultType iterateLoaders(String resourcePath, LoaderIterator<ResultType, ParameterType, ParameterType2> iterator, ParameterType parameter, ParameterType2 parameter2) {
        Loader[] loaders;
        String packageName;
        int hash;
        TIntObjectHashMap<Object> map = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
        Object o = map.get(hash = (packageName = ClasspathCache.getPackageName(resourcePath)).hashCode());
        if (o == null) {
            return null;
        }
        if (o instanceof Loader) {
            return iterator.process((Loader)o, parameter, parameter2);
        }
        for (Loader l : loaders = (Loader[])o) {
            ResultType result = iterator.process(l, parameter, parameter2);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static String getPackageName(String resourcePath) {
        int idx = resourcePath.lastIndexOf(47);
        return idx > 0 ? resourcePath.substring(0, idx) : "";
    }

    public void addNameEntry(String name, Loader loader) {
        name = this.transformName(name);
        if (this.myTempMapMode) {
            Set<Loader> loaders = this.myResources2LoadersTempMap.get(name);
            if (loaders == null) {
                loaders = new THashSet<Loader>();
                this.myResources2LoadersTempMap.put(name, loaders);
            }
            boolean added = loaders.add(loader);
            if (UrlClassLoader.doDebug && added) {
                ++this.registeredBeforeClose;
            }
        } else {
            if (UrlClassLoader.doDebug && !this.myNameFilter.maybeContains(name, loader)) {
                ++this.registeredAfterClose;
            }
            this.myNameFilter.add(name, loader);
        }
    }

    public boolean loaderHasName(String name, Loader loader) {
        boolean result;
        String origName = name;
        name = this.transformName(name);
        if (this.myTempMapMode) {
            ++requests;
            Set<Loader> loaders = this.myResources2LoadersTempMap.get(name);
            boolean bl = result = loaders != null && loaders.contains(loader);
            if (!result) {
                ++hits;
            }
            if (requests % 1000 == 0 && UrlClassLoader.doDebug) {
                UrlClassLoader.debug("Avoided disk hits: " + hits + " from " + requests + "");
            }
        } else {
            ++requests2;
            result = this.myNameFilter.maybeContains(name, loader);
            if (!result) {
                ++hits2;
            }
            if (requests2 % 1000 == 0 && UrlClassLoader.doDebug) {
                UrlClassLoader.debug("Avoided disk hits2: " + hits2 + " from " + requests2 + "");
            }
        }
        return result;
    }

    private String transformName(String name) {
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((name = name.substring(name.lastIndexOf(47) + 1)).endsWith(".class")) {
            String name1 = name;
            int $ = name1.indexOf(36);
            if ($ != -1) {
                name1 = name1.substring(0, $);
            } else {
                int index = name1.lastIndexOf(46);
                if (index >= 0) {
                    name1 = name1.substring(0, index);
                }
            }
            name = name1;
        }
        return name;
    }

    void nameSymbolsLoaded() {
        if (!this.myTempMapMode) {
            if (UrlClassLoader.doDebug && this.registeredAfterClose > 0) {
                UrlClassLoader.debug("Registered number of classes after close " + this.registeredAfterClose + " " + this.toString());
            }
            return;
        }
        if (UrlClassLoader.doDebug) {
            UrlClassLoader.debug("Registered number of classes before classes " + this.registeredBeforeClose + " " + this.toString());
        }
        this.myTempMapMode = false;
        int nBits = 0;
        int uniques = 0;
        for (Map.Entry<String, Set<Loader>> e : this.myResources2LoadersTempMap.entrySet()) {
            int size = e.getValue().size();
            if (size == 1) {
                ++uniques;
            }
            nBits += size;
        }
        if (nBits > 20000) {
            nBits += (int)((double)nBits * 0.03);
        }
        this.myNameFilter = new Name2LoaderFilter(nBits, 0.005);
        for (Map.Entry<String, Set<Loader>> e : this.myResources2LoadersTempMap.entrySet()) {
            String name = e.getKey();
            for (Loader loader : e.getValue()) {
                this.myNameFilter.add(name, loader);
            }
        }
        this.myResources2LoadersTempMap = null;
    }

    static class DebugInfo {
        private final HashMap<String, List<Loader>> myClassPackagesCache = new HashMap();
        private final HashMap<String, List<Loader>> myResourcePackagesCache = new HashMap();
        private final TIntHashSet myResourceIndex = new TIntHashSet();

        DebugInfo() {
        }

        private List<Loader> getLoaders(String resourcePath) {
            int idx;
            String packageName;
            boolean isClassFile = resourcePath.endsWith(".class");
            HashMap<String, List<Loader>> map = isClassFile ? this.myClassPackagesCache : this.myResourcePackagesCache;
            SmartList list = (SmartList)map.get(packageName = (idx = resourcePath.lastIndexOf(47)) > 0 ? resourcePath.substring(0, idx) : "");
            if (list == null) {
                list = new SmartList();
                map.put(packageName, list);
            }
            return list;
        }

        public void checkLoadersCount(String resourcePath, Object o) {
            List<Loader> loaders1 = this.getLoaders(resourcePath);
            if (o == null && loaders1.size() != 0 || o instanceof Loader && loaders1.size() != 1 || o instanceof Loader[] && loaders1.size() != ((Loader[])o).length) assert (false);
        }
    }

    private static class Name2LoaderFilter
    extends BloomFilterBase {
        Name2LoaderFilter(int nBits, double probability) {
            super(nBits, probability);
        }

        private boolean maybeContains(String name, Loader loader) {
            int hash = this.hashFromNameAndLoader(name, loader, StringHash.murmur(name, 31));
            int hash2 = this.hashFromNameAndLoader(name, loader, hash);
            return this.maybeContains(hash, hash2);
        }

        void add(String name, Loader loader) {
            int hash = this.hashFromNameAndLoader(name, loader, StringHash.murmur(name, 31));
            int hash2 = this.hashFromNameAndLoader(name, loader, hash);
            this.addIt(hash, hash2);
        }

        private int hashFromNameAndLoader(String name, Loader loader, int n) {
            int hash = StringHash.murmur(name, n);
            for (int i = loader.getIndex(); i > 0; i /= 10) {
                hash = hash * n + (i % 10 + 48);
            }
            return hash;
        }
    }

    static abstract class LoaderIterator<ResultType, ParameterType, ParameterType2> {
        LoaderIterator() {
        }

        @Nullable
        abstract ResultType process(Loader var1, ParameterType var2, ParameterType2 var3);
    }
}

