/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.lang;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.application.PathManager;
import org.jetbrains.jet.internal.com.intellij.openapi.util.ShutDownTracker;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;
import org.jetbrains.jet.internal.com.intellij.util.containers.Stack;
import org.jetbrains.jet.internal.com.intellij.util.lang.ClasspathCache;
import org.jetbrains.jet.internal.com.intellij.util.lang.FileLoader;
import org.jetbrains.jet.internal.com.intellij.util.lang.JarLoader;
import org.jetbrains.jet.internal.com.intellij.util.lang.Loader;
import sun.misc.Resource;

public class ClassPath {
    private final Stack<URL> myUrls = new Stack();
    private final ArrayList<Loader> myLoaders = new ArrayList();
    private final HashMap<URL, Loader> myLoadersMap = new HashMap();
    private final ClasspathCache myCache = new ClasspathCache();
    private static final boolean ourDumpOrder = "true".equals(System.getProperty("idea.dump.order"));
    private final boolean myCanLockJars;
    private final boolean myCanUseCache;
    private static PrintStream ourOrder;
    private static long ourOrderSize;
    private static final Set<String> ourOrderedUrls;
    private static final String HOME;
    private final boolean myAcceptUnescapedUrls;
    private static final ResourceStringLoaderIterator checkedIterator;
    private static final ResourceStringLoaderIterator uncheckedIterator;
    private static final LoaderCollector myLoaderCollector;

    private static synchronized void printOrder(Loader loader, String url, Resource resource) {
        if (!ourOrderedUrls.add(url)) {
            return;
        }
        try {
            ourOrderSize += (long)resource.getContentLength();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        if (ourOrder == null) {
            File orderFile = new File(PathManager.getBinPath() + File.separator + "order.txt");
            try {
                if (!FileUtil.ensureCanCreateFile(orderFile)) {
                    return;
                }
                ourOrder = new PrintStream(new FileOutputStream(orderFile, true));
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        ourOrder.close();
                        System.out.println(ourOrderSize);
                    }
                });
            }
            catch (IOException e) {
                return;
            }
        }
        if (ourOrder != null) {
            String jarURL = FileUtil.toSystemIndependentName(loader.getBaseURL().getFile());
            if ((jarURL = StringUtil.trimStart(jarURL, "file:/")).startsWith(HOME)) {
                jarURL = jarURL.replaceFirst(HOME, "");
                jarURL = StringUtil.trimEnd(jarURL, "!/");
                ourOrder.println(url + ":" + jarURL);
            }
        }
    }

    public ClassPath(URL[] urls, boolean canLockJars, boolean canUseCache) {
        this(urls, canLockJars, canUseCache, false);
    }

    public ClassPath(URL[] urls, boolean canLockJars, boolean canUseCache, boolean acceptUnescapedUrls) {
        this.myCanLockJars = canLockJars;
        this.myCanUseCache = canUseCache;
        this.myAcceptUnescapedUrls = acceptUnescapedUrls;
        this.push(urls);
    }

    void addURL(URL url) {
        this.push(new URL[]{url});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Resource getResource(String s, boolean flag) {
        int i;
        long started = 0L;
        if (this.myCanUseCache) {
            Resource prevResource = this.myCache.iterateLoaders(s, flag ? checkedIterator : uncheckedIterator, s, this);
            if (prevResource != null) {
                return prevResource;
            }
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                if (this.myUrls.isEmpty()) {
                    return null;
                }
            }
            i = this.myLoaders.size();
        } else {
            i = 0;
        }
        while (true) {
            Resource resource;
            Loader loader;
            if ((loader = this.getLoader(i)) == null) {
                return null;
            }
            if ((!this.myCanUseCache || this.myCache.loaderHasName(s, loader)) && (resource = loader.getResource(s, flag)) != null) {
                return resource;
            }
            ++i;
        }
    }

    public Enumeration<URL> getResources(String name, boolean check) {
        return new MyEnumeration(name, check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Loader getLoader(int i) {
        while (this.myLoaders.size() < i + 1) {
            Loader loader;
            boolean lastOne;
            URL url;
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                if (this.myUrls.empty()) {
                    if (this.myCanUseCache) {
                        this.myCache.nameSymbolsLoaded();
                    }
                    return null;
                }
                url = this.myUrls.pop();
                lastOne = this.myUrls.isEmpty();
            }
            if (this.myLoadersMap.containsKey(url)) continue;
            try {
                loader = this.getLoader(url, this.myLoaders.size());
                if (loader == null) {
                }
            }
            catch (IOException ioexception) {}
            continue;
            this.myLoaders.add(loader);
            this.myLoadersMap.put(url, loader);
            if (!lastOne || !this.myCanUseCache) continue;
            this.myCache.nameSymbolsLoaded();
        }
        return this.myLoaders.get(i);
    }

    @Nullable
    private Loader getLoader(URL url, int index) throws IOException {
        String s;
        if (this.myAcceptUnescapedUrls) {
            s = url.getFile();
        } else {
            try {
                s = url.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException thisShouldNotHappen) {
                thisShouldNotHappen.printStackTrace();
                s = url.getFile();
            }
        }
        Loader loader = null;
        if (s != null && new File(s).isDirectory()) {
            if ("file".equals(url.getProtocol())) {
                loader = new FileLoader(url, index);
            }
        } else {
            JarLoader jarLoader = new JarLoader(url, this.myCanLockJars, index);
            jarLoader.preLoadClasses();
            loader = jarLoader;
        }
        if (loader != null && this.myCanUseCache) {
            try {
                loader.buildCache(this.myCache);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] urls) {
        if (urls.length == 0) {
            return;
        }
        Stack<URL> stack = this.myUrls;
        synchronized (stack) {
            for (int i = urls.length - 1; i >= 0; --i) {
                this.myUrls.push(urls[i]);
            }
        }
    }

    static {
        ourOrderedUrls = new HashSet<String>();
        HOME = FileUtil.toSystemIndependentName(PathManager.getHomePath());
        checkedIterator = new ResourceStringLoaderIterator(true);
        uncheckedIterator = new ResourceStringLoaderIterator(false);
        myLoaderCollector = new LoaderCollector();
    }

    private static class LoaderCollector
    extends ClasspathCache.LoaderIterator<Object, List<Loader>, Object> {
        private LoaderCollector() {
        }

        @Override
        Object process(Loader loader, List<Loader> parameter, Object parameter2) {
            parameter.add(loader);
            return null;
        }
    }

    private static class ResourceStringLoaderIterator
    extends ClasspathCache.LoaderIterator<Resource, String, ClassPath> {
        private final boolean myFlag;

        private ResourceStringLoaderIterator(boolean flag) {
            this.myFlag = flag;
        }

        @Override
        Resource process(Loader loader, String s, ClassPath classPath) {
            if (!classPath.myCache.loaderHasName(s, loader)) {
                return null;
            }
            Resource resource = loader.getResource(s, this.myFlag);
            if (resource != null) {
                if (ourDumpOrder) {
                    ClassPath.printOrder(loader, s, resource);
                }
                return resource;
            }
            return null;
        }
    }

    private class MyEnumeration
    implements Enumeration<URL> {
        private int myIndex = 0;
        private Resource myRes = null;
        private final String myName;
        private final boolean myCheck;
        private final List<Loader> myLoaders;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MyEnumeration(String name, boolean check) {
            this.myName = name;
            this.myCheck = check;
            SmartList loaders = null;
            if (ClassPath.this.myCanUseCache) {
                Stack stack = ClassPath.this.myUrls;
                synchronized (stack) {
                    if (ClassPath.this.myUrls.isEmpty()) {
                        loaders = new SmartList();
                        ClassPath.this.myCache.iterateLoaders(name, myLoaderCollector, loaders, this);
                        if (!name.endsWith("/")) {
                            ClassPath.this.myCache.iterateLoaders(name.concat("/"), myLoaderCollector, loaders, this);
                        }
                    }
                }
            }
            this.myLoaders = loaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            Loader loader;
            block7: {
                if (this.myRes != null) {
                    return true;
                }
                long started = 0L;
                if (this.myLoaders == null) break block7;
                while (this.myIndex < this.myLoaders.size()) {
                    Loader loader2 = this.myLoaders.get(this.myIndex++);
                    if (!ClassPath.this.myCache.loaderHasName(this.myName, loader2)) {
                        this.myRes = null;
                        continue;
                    }
                    this.myRes = loader2.getResource(this.myName, this.myCheck);
                    if (this.myRes == null) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            while ((loader = ClassPath.this.getLoader(this.myIndex++)) != null) {
                if (!ClassPath.this.myCache.loaderHasName(this.myName, loader)) continue;
                this.myRes = loader.getResource(this.myName, this.myCheck);
                if (this.myRes == null) continue;
                boolean bl = true;
                return bl;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.myRes;
            this.myRes = null;
            return resource.getURL();
        }
    }
}

