/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io.zip;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.io.zip.DosTime;
import org.jetbrains.jet.internal.com.intellij.util.io.zip.JBZipEntry;
import org.jetbrains.jet.internal.com.intellij.util.io.zip.JBZipOutputStream;
import org.jetbrains.jet.internal.com.intellij.util.io.zip.ZipLong;
import org.jetbrains.jet.internal.com.intellij.util.io.zip.ZipShort;

public class JBZipFile {
    private final List<JBZipEntry> entries = new ArrayList<JBZipEntry>(509);
    private final Map<String, JBZipEntry> nameMap = new HashMap<String, JBZipEntry>(509);
    private final String encoding;
    final RandomAccessFile archive;
    private JBZipOutputStream myOutputStream;
    private long currentcfdfoffset = 0L;

    public JBZipFile(File f) throws IOException {
        this(f, "UTF-8");
    }

    public JBZipFile(String name) throws IOException {
        this(new File(name), "UTF-8");
    }

    public JBZipFile(String name, String encoding) throws IOException {
        this(new File(name), encoding);
    }

    public JBZipFile(File f, String encoding) throws IOException {
        this.encoding = encoding;
        this.archive = new RandomAccessFile(f, "rw");
        try {
            if (this.archive.length() > 0L) {
                this.populateFromCentralDirectory();
            } else {
                this.getOutputStream();
            }
        }
        catch (IOException e) {
            try {
                this.archive.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        if (this.myOutputStream != null) {
            if (this.entries.isEmpty()) {
                JBZipEntry empty = this.getOrCreateEntry("/empty.file.marker");
                this.myOutputStream.putNextEntryBytes(empty, "empty".getBytes());
            }
            this.myOutputStream.finish();
            this.archive.setLength(this.myOutputStream.written);
        }
        this.archive.close();
    }

    public List<JBZipEntry> getEntries() {
        return this.entries;
    }

    public JBZipEntry getEntry(String name) {
        return this.nameMap.get(name);
    }

    public JBZipEntry getOrCreateEntry(String name) {
        JBZipEntry entry = this.nameMap.get(name);
        if (entry != null) {
            return entry;
        }
        entry = new JBZipEntry(name, this);
        this.nameMap.put(name, entry);
        this.entries.add(entry);
        return entry;
    }

    private void populateFromCentralDirectory() throws IOException {
        this.positionAtCentralDirectory();
        byte[] cfh = new byte[42];
        byte[] signatureBytes = new byte[4];
        this.archive.readFully(signatureBytes);
        long sig = ZipLong.getValue(signatureBytes);
        long cfhSig = ZipLong.getValue(JBZipOutputStream.CFH_SIG);
        while (sig == cfhSig) {
            this.archive.readFully(cfh);
            int off = 0;
            int versionMadeBy = ZipShort.getValue(cfh, off);
            off += 2;
            int platform = versionMadeBy >> 8 & 0xF;
            int method = ZipShort.getValue(cfh, off += 4);
            long time = DosTime.dosToJavaTime(ZipLong.getValue(cfh, off += 2));
            long crc = ZipLong.getValue(cfh, off += 4);
            long compressedSize = ZipLong.getValue(cfh, off += 4);
            long uncompressedSize = ZipLong.getValue(cfh, off += 4);
            int fileNameLen = ZipShort.getValue(cfh, off += 4);
            int extraLen = ZipShort.getValue(cfh, off += 2);
            int commentLen = ZipShort.getValue(cfh, off += 2);
            off += 2;
            int internalAttributes = ZipShort.getValue(cfh, off += 2);
            long externalAttributes = ZipLong.getValue(cfh, off += 2);
            long localHeaderOffset = ZipLong.getValue(cfh, off += 4);
            String name = this.getString(this.readBytes(fileNameLen));
            byte[] extra = this.readBytes(extraLen);
            String comment = this.getString(this.readBytes(commentLen));
            JBZipEntry ze = new JBZipEntry(this);
            ze.setName(name);
            ze.setHeaderOffset(localHeaderOffset);
            ze.setPlatform(platform);
            ze.setMethod(method);
            ze.setTime(time);
            ze.setCrc(crc);
            ze.setCompressedSize(compressedSize);
            ze.setSize(uncompressedSize);
            ze.setInternalAttributes(internalAttributes);
            ze.setExternalAttributes(externalAttributes);
            ze.setExtra(extra);
            try {
                ze.setComment(comment);
            }
            catch (IllegalArgumentException e) {
                ze.setComment(comment.substring(0, 21845));
            }
            this.nameMap.put(ze.getName(), ze);
            this.entries.add(ze);
            this.archive.readFully(signatureBytes);
            sig = ZipLong.getValue(signatureBytes);
        }
    }

    private byte[] readBytes(int count) throws IOException {
        if (count > 0) {
            byte[] bytes = new byte[count];
            this.archive.readFully(bytes);
            return bytes;
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    private void positionAtCentralDirectory() throws IOException {
        boolean found = false;
        long off = this.archive.length() - 22L;
        if (off >= 0L) {
            this.archive.seek(off);
            byte[] sig = JBZipOutputStream.EOCD_SIG;
            int curr = this.archive.read();
            while (curr != -1) {
                if (curr == sig[0] && (curr = this.archive.read()) == sig[1] && (curr = this.archive.read()) == sig[2] && (curr = this.archive.read()) == sig[3]) {
                    found = true;
                    break;
                }
                this.archive.seek(--off);
                curr = this.archive.read();
            }
        }
        if (!found) {
            throw new ZipException("archive is not a ZIP archive");
        }
        this.archive.seek(off + 16L);
        byte[] cfdOffset = new byte[4];
        this.archive.readFully(cfdOffset);
        this.currentcfdfoffset = ZipLong.getValue(cfdOffset);
        this.archive.seek(this.currentcfdfoffset);
    }

    String getString(byte[] bytes) throws ZipException {
        if (this.encoding == null) {
            return new String(bytes);
        }
        try {
            return new String(bytes, this.encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ZipException(uee.getMessage());
        }
    }

    public void eraseEntry(JBZipEntry entry) throws IOException {
        this.getOutputStream();
        this.entries.remove(entry);
        this.nameMap.remove(entry.getName());
    }

    JBZipOutputStream getOutputStream() throws IOException {
        if (this.myOutputStream == null) {
            this.myOutputStream = new JBZipOutputStream(this, this.currentcfdfoffset);
        }
        return this.myOutputStream;
    }
}

