/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io.storage;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.ByteSequence;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.StreamUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentHashMap;
import org.jetbrains.jet.internal.com.intellij.util.io.PagePool;
import org.jetbrains.jet.internal.com.intellij.util.io.UnsyncByteArrayInputStream;
import org.jetbrains.jet.internal.com.intellij.util.io.storage.AbstractRecordsTable;
import org.jetbrains.jet.internal.com.intellij.util.io.storage.AbstractStorage;
import org.jetbrains.jet.internal.com.intellij.util.io.storage.RefCountingRecordsTable;

public class RefCountingStorage
extends AbstractStorage {
    private final Map<Integer, Future<?>> myPendingWriteRequests = new ConcurrentHashMap();
    private int myPendingWriteRequestsSize;
    private final ThreadPoolExecutor myPendingWriteRequestsExecutor = new ThreadPoolExecutor(1, 1, Long.MAX_VALUE, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "RefCountingStorage write content helper");
        }
    });
    private final boolean myDoNotZipCaches = Boolean.valueOf(System.getProperty("idea.doNotZipCaches"));

    public RefCountingStorage(String path) throws IOException {
        super(path);
    }

    @Override
    public DataInputStream readStream(int record) throws IOException {
        if (this.myDoNotZipCaches) {
            return super.readStream(record);
        }
        BufferExposingByteArrayOutputStream stream = this.internalReadStream(record);
        return new DataInputStream(new UnsyncByteArrayInputStream(stream.getInternalBuffer(), 0, stream.size()));
    }

    @Override
    protected byte[] readBytes(int record) throws IOException {
        if (this.myDoNotZipCaches) {
            return super.readBytes(record);
        }
        return this.internalReadStream(record).toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferExposingByteArrayOutputStream internalReadStream(int record) throws IOException {
        this.waitForPendingWriteForRecord(record);
        Object object = this.myLock;
        synchronized (object) {
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream;
            byte[] result = super.readBytes(record);
            InflaterInputStream in = new InflaterInputStream(new UnsyncByteArrayInputStream(result));
            try {
                BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
                StreamUtil.copyStreamContent(in, outputStream);
                bufferExposingByteArrayOutputStream = outputStream;
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return bufferExposingByteArrayOutputStream;
        }
    }

    private void waitForPendingWriteForRecord(int record) {
        Future<?> future = this.myPendingWriteRequests.get(record);
        if (future != null) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void appendBytes(int record, ByteSequence bytes) throws IOException {
        throw new IncorrectOperationException("Appending is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBytes(final int record, final ByteSequence bytes, final boolean fixedSize) throws IOException {
        if (this.myDoNotZipCaches) {
            super.writeBytes(record, bytes, fixedSize);
            return;
        }
        this.waitForPendingWriteForRecord(record);
        Object object = this.myLock;
        synchronized (object) {
            this.myPendingWriteRequestsSize += bytes.getLength();
            if (this.myPendingWriteRequestsSize > 0x1400000) {
                this.zipAndWrite(bytes, record, fixedSize);
            } else {
                this.myPendingWriteRequests.put(record, this.myPendingWriteRequestsExecutor.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws IOException {
                        RefCountingStorage.this.zipAndWrite(bytes, record, fixedSize);
                        return null;
                    }
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipAndWrite(ByteSequence bytes, int record, boolean fixedSize) throws IOException {
        BufferExposingByteArrayOutputStream s = new BufferExposingByteArrayOutputStream();
        DeflaterOutputStream out = new DeflaterOutputStream(s);
        try {
            out.write(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
        }
        finally {
            out.close();
        }
        Object object = this.myLock;
        synchronized (object) {
            this.doWrite(record, fixedSize, s);
            this.myPendingWriteRequestsSize -= bytes.getLength();
            this.myPendingWriteRequests.remove(record);
        }
    }

    private void doWrite(int record, boolean fixedSize, BufferExposingByteArrayOutputStream s) throws IOException {
        super.writeBytes(record, new ByteSequence(s.getInternalBuffer(), 0, s.size()), fixedSize);
    }

    @Override
    protected AbstractRecordsTable createRecordsTable(PagePool pool, File recordsFile) throws IOException {
        return new RefCountingRecordsTable(recordsFile, pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acquireNewRecord() throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            int record = this.myRecordsTable.createNewRecord();
            ((RefCountingRecordsTable)this.myRecordsTable).incRefCount(record);
            return record;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireRecord(int record) {
        this.waitForPendingWriteForRecord(record);
        Object object = this.myLock;
        synchronized (object) {
            ((RefCountingRecordsTable)this.myRecordsTable).incRefCount(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRecord(int record) throws IOException {
        this.waitForPendingWriteForRecord(record);
        Object object = this.myLock;
        synchronized (object) {
            if (((RefCountingRecordsTable)this.myRecordsTable).decRefCount(record)) {
                this.doDeleteRecord(record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefCount(int record) {
        this.waitForPendingWriteForRecord(record);
        Object object = this.myLock;
        synchronized (object) {
            return ((RefCountingRecordsTable)this.myRecordsTable).getRefCount(record);
        }
    }

    @Override
    public void force() {
        this.flushPendingWrites();
        super.force();
    }

    @Override
    public boolean isDirty() {
        return this.myPendingWriteRequests.size() > 0 || super.isDirty();
    }

    @Override
    public boolean flushSome() {
        this.flushPendingWrites();
        return super.flushSome();
    }

    @Override
    public void dispose() {
        this.flushPendingWrites();
        super.dispose();
    }

    @Override
    public void checkSanity(int record) {
        this.flushPendingWrites();
        super.checkSanity(record);
    }

    private void flushPendingWrites() {
        for (Map.Entry<Integer, Future<?>> entry : this.myPendingWriteRequests.entrySet()) {
            try {
                entry.getValue().get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

