/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io.storage;

import java.io.File;
import java.io.IOException;
import org.jetbrains.jet.internal.com.intellij.util.io.PagePool;
import org.jetbrains.jet.internal.com.intellij.util.io.storage.AbstractRecordsTable;

class RefCountingRecordsTable
extends AbstractRecordsTable {
    private static final byte[] ZEROES = new byte[20];

    public RefCountingRecordsTable(File recordsFile, PagePool pool) throws IOException {
        super(recordsFile, pool);
    }

    @Override
    protected int getImplVersion() {
        return 1;
    }

    @Override
    protected int getRecordSize() {
        return 20;
    }

    @Override
    protected byte[] getZeros() {
        return ZEROES;
    }

    public void incRefCount(int record) {
        this.markDirty();
        int offset = this.getOffset(record, 16);
        this.myStorage.putInt(offset, this.myStorage.getInt(offset) + 1);
    }

    public boolean decRefCount(int record) {
        this.markDirty();
        int offset = this.getOffset(record, 16);
        int count = this.myStorage.getInt(offset);
        assert (count > 0);
        this.myStorage.putInt(offset, --count);
        return count == 0;
    }

    public int getRefCount(int record) {
        return this.myStorage.getInt(this.getOffset(record, 16));
    }
}

