/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io.storage;

import java.io.File;
import java.io.IOException;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.Forceable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.util.io.PagePool;
import org.jetbrains.jet.internal.com.intellij.util.io.RandomAccessDataFile;

class DataTable
implements Disposable,
Forceable {
    private static final Logger LOG = Logger.getInstance("org.jetbrains.jet.internal.com.intellij.util.io.storage.DataTable");
    private final RandomAccessDataFile myFile;
    private volatile int myWasteSize;
    private boolean myIsDirty = false;

    public DataTable(File filePath, PagePool pool) throws IOException {
        this.myFile = new RandomAccessDataFile(filePath, pool);
        if (this.myFile.length() == 0L) {
            this.markDirty();
        } else {
            this.readInHeader(filePath);
        }
    }

    public boolean isCompactNecessary() {
        return (double)this.myWasteSize / (double)this.myFile.length() > 0.25 && this.myWasteSize > 0x300000;
    }

    private void readInHeader(File filePath) throws IOException {
        int magic = this.myFile.getInt(0L);
        if (magic != 523190095) {
            this.myFile.dispose();
            throw new IOException("Records table for '" + filePath + "' haven't been closed correctly. Rebuild required.");
        }
        this.myWasteSize = this.myFile.getInt(4L);
    }

    public void readBytes(long address, byte[] bytes) {
        this.myFile.get(address, bytes, 0, bytes.length);
    }

    public void writeBytes(long address, byte[] bytes) {
        this.writeBytes(address, bytes, 0, bytes.length);
    }

    public void writeBytes(long address, byte[] bytes, int off, int len) {
        this.markDirty();
        this.myFile.put(address, bytes, off, len);
    }

    public long allocateSpace(int len) {
        long result = Math.max(this.myFile.length(), 32L);
        long newLenght = result + (long)len;
        this.writeBytes(newLenght - 1L, new byte[]{0});
        long actualLenght = this.myFile.length();
        LOG.assertTrue(actualLenght == newLenght, "Failed to resize the storage at: " + this.myFile.getFile() + ". Required: " + newLenght + ", actual: " + actualLenght);
        return result;
    }

    public void reclaimSpace(int len) {
        if (len > 0) {
            this.markDirty();
            this.myWasteSize += len;
        }
    }

    @Override
    public void dispose() {
        if (!this.myFile.isDisposed()) {
            this.markClean();
            this.myFile.dispose();
        }
    }

    @Override
    public void force() {
        this.markClean();
        this.myFile.force();
    }

    public boolean flushSome(int maxPages) {
        this.myFile.flushSomePages(maxPages);
        if (!this.myFile.isDirty()) {
            this.force();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.myIsDirty || this.myFile.isDirty();
    }

    private void markClean() {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.fillInHeader(523190095, this.myWasteSize);
        }
    }

    private void markDirty() {
        if (!this.myIsDirty) {
            this.myIsDirty = true;
            this.fillInHeader(313341156, 0);
        }
    }

    private void fillInHeader(int magic, int wasteSize) {
        this.myFile.putInt(0L, magic);
        this.myFile.putInt(4L, wasteSize);
    }

    public int getWaste() {
        return this.myWasteSize;
    }

    public long getFileSize() {
        return this.myFile.length();
    }
}

