/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;

public class URLUtil {
    private URLUtil() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static InputStream openStream(URL url) throws IOException {
        InputStream inputStream;
        String protocol = url.getProtocol();
        if (protocol.equals("jar")) {
            inputStream = URLUtil.openJarStream(url);
            if (inputStream == null) throw new IllegalStateException("@NotNull method com/intellij/util/io/URLUtil.openStream must not return null");
            return inputStream;
        }
        inputStream = url.openStream();
        if (inputStream != null) return inputStream;
        throw new IllegalStateException("@NotNull method com/intellij/util/io/URLUtil.openStream must not return null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static InputStream openResourceStream(URL url) throws IOException {
        InputStream inputStream;
        InputStream inputStream2;
        try {
            inputStream2 = URLUtil.openStream(url);
        }
        catch (FileNotFoundException ex) {
            InputStream resourceStream;
            int pos;
            String protocol = url.getProtocol();
            String file = null;
            if (protocol.equals("file")) {
                file = url.getFile();
            } else if (protocol.equals("jar") && (pos = url.getFile().indexOf("!")) >= 0) {
                file = url.getFile().substring(pos + 1);
            }
            if (file == null || !file.startsWith("/") || (resourceStream = URLUtil.class.getResourceAsStream(file)) == null) throw ex;
            inputStream = resourceStream;
            if (inputStream == null) throw new IllegalStateException("@NotNull method com/intellij/util/io/URLUtil.openResourceStream must not return null");
            return inputStream;
        }
        inputStream = inputStream2;
        if (inputStream2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/io/URLUtil.openResourceStream must not return null");
        return inputStream;
    }

    @NotNull
    private static InputStream openJarStream(URL url) throws IOException {
        String file = url.getFile();
        assert (file.startsWith("file:"));
        file = file.substring("file:".length());
        assert (file.indexOf("!/") > 0);
        String resource = file.substring(file.indexOf("!/") + 2);
        final ZipFile zipFile = new ZipFile(FileUtil.unquote(file = file.substring(0, file.indexOf("!"))));
        ZipEntry zipEntry = zipFile.getEntry(resource);
        if (zipEntry == null) {
            throw new FileNotFoundException("Entry " + resource + " not found in " + file);
        }
        FilterInputStream filterInputStream = new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
        if (filterInputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/io/URLUtil.openJarStream must not return null");
        }
        return filterInputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/URLUtil.unescapePercentSequences must not be null");
        }
        if (s.indexOf(37) == -1) {
            string = s;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/util/io/URLUtil.unescapePercentSequences must not return null");
            return string;
        }
        StringBuilder decoded = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                ArrayList<Integer> bytes = new ArrayList<Integer>();
                while (i + 2 < len && s.charAt(i) == '%') {
                    int d1 = URLUtil.decode(s.charAt(i + 1));
                    int d2 = URLUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = (byte)((Integer)bytes.get(j)).intValue();
                    }
                    try {
                        decoded.append(new String(bytesArray, "UTF-8"));
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
            decoded.append(c);
            ++i;
        }
        string = decoded.toString();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/util/io/URLUtil.unescapePercentSequences must not return null");
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }
}

