/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.jet.internal.com.intellij.util.io.DataInputOutputUtil;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentStringEnumerator;

public class StringRef {
    public static final StringRef[] EMPTY_ARRAY = new StringRef[0];
    private int id;
    private String name;
    private final PersistentStringEnumerator store;

    private StringRef(String name) {
        this.name = name;
        this.id = -1;
        this.store = null;
    }

    private StringRef(int id, PersistentStringEnumerator store) {
        this.id = id;
        this.store = store;
        this.name = null;
    }

    public String getString() {
        if (this.name == null) {
            try {
                this.name = this.store.valueOf(this.id);
            }
            catch (IOException e) {
                this.store.markCorrupted();
                throw new RuntimeException(e);
            }
        }
        return this.name;
    }

    public void writeTo(DataOutput out, PersistentStringEnumerator store) throws IOException {
        int nameId = this.getId(store);
        out.writeByte(nameId & 0xFF);
        DataInputOutputUtil.writeINT(out, nameId >> 8);
    }

    public int getId(PersistentStringEnumerator store) {
        if (this.id == -1) {
            try {
                this.id = store.enumerate(this.name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.id;
    }

    public String toString() {
        return this.getString();
    }

    public int length() {
        return this.getString().length();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object that) {
        return that == this || that instanceof StringRef && this.toString().equals(that.toString());
    }

    public static String toString(StringRef ref) {
        return ref != null ? ref.getString() : null;
    }

    public static StringRef fromString(String source) {
        return source == null ? null : new StringRef(source);
    }

    public static StringRef fromStream(DataInput in, PersistentStringEnumerator store) throws IOException {
        int low = in.readUnsignedByte();
        int nameId = DataInputOutputUtil.readINT(in) << 8 | low;
        return nameId != 0 ? new StringRef(nameId, store) : null;
    }

    public static StringRef[] createArray(int count) {
        return count == 0 ? EMPTY_ARRAY : new StringRef[count];
    }
}

