/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.jet.internal.com.intellij.CommonBundle;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileSystemUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;

public class SafeFileOutputStream
extends OutputStream {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.SafeFileOutputStream");
    private final File myTargetFile;
    private final boolean myPreserveAttributes;
    private final File myBackDoorFile;
    private final OutputStream myBackDoorStream;
    private boolean failed = false;

    public SafeFileOutputStream(File target) throws FileNotFoundException {
        this(target, false);
    }

    public SafeFileOutputStream(File target, boolean preserveAttributes) throws FileNotFoundException {
        this.myTargetFile = target;
        this.myPreserveAttributes = preserveAttributes;
        this.myBackDoorFile = new File(this.myTargetFile.getParentFile(), this.myTargetFile.getName() + "___jb_bak___");
        this.myBackDoorStream = new FileOutputStream(this.myBackDoorFile);
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.myBackDoorStream.write(b);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.myBackDoorStream.write(b);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.myBackDoorStream.write(b, off, len);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.myBackDoorStream.flush();
        }
        catch (IOException e) {
            LOG.warn(e);
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.myBackDoorStream.close();
        }
        catch (IOException e) {
            LOG.warn(e);
            FileUtil.delete(this.myBackDoorFile);
            throw e;
        }
        if (this.failed) {
            throw new IOException(CommonBundle.message("safe.write.failed", this.myTargetFile, this.myBackDoorFile.getName()));
        }
        int permissions = this.myPreserveAttributes ? FileSystemUtil.getPermissions(this.myTargetFile) : -1;
        File oldFile = new File(this.myTargetFile.getParent(), this.myTargetFile.getName() + "___jb_old___");
        try {
            FileUtil.rename(this.myTargetFile, oldFile);
        }
        catch (IOException e) {
            LOG.warn(e);
            throw new IOException(CommonBundle.message("safe.write.rename.original", this.myTargetFile, this.myBackDoorFile.getName()));
        }
        try {
            FileUtil.rename(this.myBackDoorFile, this.myTargetFile);
        }
        catch (IOException e) {
            LOG.warn(e);
            throw new IOException(CommonBundle.message("safe.write.rename.backup", this.myTargetFile, oldFile.getName(), this.myBackDoorFile.getName()));
        }
        if (permissions != -1) {
            FileSystemUtil.setPermissions(this.myTargetFile, permissions);
        }
        if (!FileUtil.delete(oldFile)) {
            throw new IOException(CommonBundle.message("safe.write.drop.temp", oldFile));
        }
    }
}

