/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentSLRUMap;
import org.jetbrains.jet.internal.com.intellij.util.io.EnumeratorStringDescriptor;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentEnumeratorDelegate;

public class PersistentStringEnumerator
extends PersistentEnumeratorDelegate<String> {
    @Nullable
    private final ConcurrentSLRUMap<Integer, String> myIdToStringCache;
    @Nullable
    private final ConcurrentSLRUMap<Integer, Integer> myHashcodeToIdCache;

    public PersistentStringEnumerator(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentStringEnumerator.<init> must not be null");
        }
        this(file, 4096);
    }

    public PersistentStringEnumerator(@NotNull File file, boolean cacheLastMappings) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentStringEnumerator.<init> must not be null");
        }
        this(file, 4096, cacheLastMappings);
    }

    public PersistentStringEnumerator(@NotNull File file, int initialSize) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentStringEnumerator.<init> must not be null");
        }
        this(file, initialSize, false);
    }

    private PersistentStringEnumerator(@NotNull File file, int initialSize, boolean cacheLastMappings) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentStringEnumerator.<init> must not be null");
        }
        super(file, new EnumeratorStringDescriptor(), initialSize);
        if (cacheLastMappings) {
            this.myIdToStringCache = new ConcurrentSLRUMap(8192, 8192);
            this.myHashcodeToIdCache = new ConcurrentSLRUMap(8192, 8192);
        } else {
            this.myIdToStringCache = null;
            this.myHashcodeToIdCache = null;
        }
    }

    @Override
    public int enumerate(@Nullable String value) throws IOException {
        String s;
        Integer cachedId;
        int valueHashCode = -1;
        if (this.myHashcodeToIdCache != null && value != null && (cachedId = this.myHashcodeToIdCache.get(valueHashCode = value.hashCode())) != null && (s = this.myIdToStringCache.get(cachedId)) != null && value.equals(s)) {
            return cachedId;
        }
        int enumerate = super.enumerate(value);
        Integer enumeratedInteger = null;
        if (this.myHashcodeToIdCache != null) {
            enumeratedInteger = enumerate;
            if (value != null) {
                this.myHashcodeToIdCache.put(valueHashCode, enumeratedInteger);
            }
        }
        if (this.myIdToStringCache != null) {
            this.myIdToStringCache.put(enumeratedInteger, value);
        }
        return enumerate;
    }

    @Override
    @Nullable
    public String valueOf(int idx) throws IOException {
        String s;
        if (this.myIdToStringCache != null && (s = this.myIdToStringCache.get(idx)) != null) {
            return s;
        }
        s = (String)super.valueOf(idx);
        if (this.myIdToStringCache != null && s != null) {
            this.myIdToStringCache.put(idx, s);
        }
        return s;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.myIdToStringCache != null) {
            this.myIdToStringCache.clear();
        }
        if (this.myHashcodeToIdCache != null) {
            this.myHashcodeToIdCache.clear();
        }
    }

    public void markCorrupted() {
        this.myEnumerator.markCorrupted();
    }
}

