/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.ByteSequence;
import org.jetbrains.jet.internal.com.intellij.util.containers.SLRUCache;
import org.jetbrains.jet.internal.com.intellij.util.io.Bits;
import org.jetbrains.jet.internal.com.intellij.util.io.DataOutputStream;
import org.jetbrains.jet.internal.com.intellij.util.io.IOStatistics;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentEnumeratorBase;

public class PersistentHashMapValueStorage {
    @Nullable
    private RAReader myCompactionModeReader = null;
    private long mySize;
    private final File myFile;
    private final String myPath;
    private boolean myCompactionMode = false;
    private static final FileAccessorCache<DataOutputStream> ourAppendersCache = new FileAccessorCache<DataOutputStream>(10, 20){

        @Override
        @NotNull
        public CacheValue<DataOutputStream> createValue(String path) {
            try {
                CachedAppender cachedAppender = new CachedAppender(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true))));
                if (cachedAppender == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMapValueStorage$1.createValue must not return null");
                }
                return cachedAppender;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final FileAccessorCache<RAReader> ourReadersCache = new FileAccessorCache<RAReader>(10, 20){

        @Override
        @NotNull
        public CacheValue<RAReader> createValue(String path) {
            CachedReader cachedReader = new CachedReader(new FileReader(new File(path)));
            if (cachedReader == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMapValueStorage$2.createValue must not return null");
            }
            return cachedReader;
        }
    };
    private long smallWrites;
    private int smallWritesCount;
    private long largeWrites;
    private int largeWritesCount;
    private int requests;
    private final byte[] myBuffer = new byte[1024];

    public PersistentHashMapValueStorage(String path) throws IOException {
        this.myPath = path;
        this.myFile = new File(path);
        this.mySize = this.myFile.length();
        if (this.mySize == 0L) {
            this.appendBytes(new ByteSequence("Header Record For PersistentHashMapValuStorage".getBytes()), 0L);
        }
    }

    public long appendBytes(ByteSequence data, long prevChunkAddress) throws IOException {
        return this.appendBytes(data.getBytes(), data.getOffset(), data.getLength(), prevChunkAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long appendBytes(byte[] data, int offset, int dataLength, long prevChunkAddress) throws IOException {
        int serviceFieldsSizeIncrease;
        assert (!this.myCompactionMode);
        long result = this.mySize;
        CacheValue<DataOutputStream> appender = ourAppendersCache.get(this.myPath);
        try {
            DataOutputStream dataOutputStream = appender.get();
            ++this.requests;
            if (dataLength + 1 < 128 && prevChunkAddress < Integer.MAX_VALUE) {
                ++this.smallWritesCount;
                this.smallWrites += (long)dataLength;
                dataOutputStream.write(-dataLength - 1);
                dataOutputStream.writeInt((int)prevChunkAddress);
                serviceFieldsSizeIncrease = 5;
            } else {
                ++this.largeWritesCount;
                this.largeWrites += (long)dataLength;
                dataOutputStream.writeInt(dataLength);
                dataOutputStream.writeLong(prevChunkAddress);
                serviceFieldsSizeIncrease = 12;
            }
            dataOutputStream.write(data, offset, dataLength);
            if (this.requests % 50000 == 0 && IOStatistics.DEBUG) {
                IOStatistics.dump("Small writes:" + this.smallWritesCount + ", bytes:" + this.smallWrites + ", largeWrites:" + this.largeWritesCount + ", bytes:" + this.largeWrites + ", total:" + this.requests + "@" + this.myFile.getPath());
            }
        }
        finally {
            appender.release();
        }
        this.mySize += (long)(dataLength + serviceFieldsSizeIncrease);
        return result;
    }

    public ReadResult readBytes(long tailChunkAddress) throws IOException {
        this.force();
        long chunk = tailChunkAddress;
        int chunkCount = 0;
        byte[] result = null;
        RAReader reader = this.myCompactionModeReader;
        CacheValue<RAReader> readerHandle = null;
        if (reader == null) {
            readerHandle = ourReadersCache.get(this.myPath);
            reader = readerHandle.get();
        }
        try {
            while (chunk != 0L) {
                byte[] b;
                long prevChunkAddress;
                int chunkSize;
                if (chunk < 0L || chunk > this.mySize) {
                    throw new PersistentEnumeratorBase.CorruptedException(this.myFile);
                }
                int len = (int)Math.min((long)this.myBuffer.length, this.mySize - chunk);
                reader.get(chunk, this.myBuffer, 0, len);
                byte sizePart = this.myBuffer[0];
                if (sizePart < 0) {
                    chunkSize = -sizePart - 1;
                    prevChunkAddress = Bits.getInt(this.myBuffer, 1);
                    b = new byte[(result != null ? result.length : 0) + chunkSize];
                    if (result != null) {
                        System.arraycopy(result, 0, b, b.length - result.length, result.length);
                    }
                    result = b;
                    PersistentHashMapValueStorage.checkPreconditions(result, chunkSize, 0);
                    System.arraycopy(this.myBuffer, 5, result, 0, chunkSize);
                } else {
                    chunkSize = Bits.getInt(this.myBuffer, 0);
                    prevChunkAddress = Bits.getLong(this.myBuffer, 4);
                    b = new byte[(result != null ? result.length : 0) + chunkSize];
                    if (result != null) {
                        System.arraycopy(result, 0, b, b.length - result.length, result.length);
                    }
                    result = b;
                    if (chunkSize < this.myBuffer.length - 12) {
                        System.arraycopy(this.myBuffer, 12, result, 0, chunkSize);
                    } else {
                        reader.get(chunk + 12L, result, 0, chunkSize);
                    }
                }
                if (prevChunkAddress >= chunk) {
                    throw new PersistentEnumeratorBase.CorruptedException(this.myFile);
                }
                chunk = prevChunkAddress;
                ++chunkCount;
                if ((long)result.length <= this.mySize) continue;
                throw new PersistentEnumeratorBase.CorruptedException(this.myFile);
            }
        }
        catch (OutOfMemoryError error) {
            result = null;
            throw new PersistentEnumeratorBase.CorruptedException(this.myFile);
        }
        finally {
            if (readerHandle != null) {
                readerHandle.release();
            }
        }
        if (chunkCount > 1 && !this.myCompactionMode) {
            long l = this.appendBytes(new ByteSequence(result), 0L);
            return new ReadResult(l, result);
        }
        return new ReadResult(tailChunkAddress, result);
    }

    public long getSize() {
        return this.mySize;
    }

    private static void checkPreconditions(byte[] result, int chunkSize, int off) throws IOException {
        if (chunkSize < 0) {
            throw new IOException("Value storage corrupted: negative chunk size");
        }
        if (off < 0) {
            throw new IOException("Value storage corrupted: negative offset");
        }
        if (chunkSize > result.length - off) {
            throw new IOException("Value storage corrupted");
        }
    }

    public void force() {
        CacheValue<DataOutputStream> cached = ourAppendersCache.getIfCached(this.myPath);
        if (cached != null) {
            try {
                cached.get().flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                cached.release();
            }
        }
    }

    public void dispose() {
        ourReadersCache.remove(this.myPath);
        ourAppendersCache.remove(this.myPath);
        if (this.myCompactionModeReader != null) {
            this.myCompactionModeReader.dispose();
            this.myCompactionModeReader = null;
        }
    }

    public void switchToCompactionMode() {
        ourReadersCache.remove(this.myPath);
        this.myCompactionModeReader = new FileReader(this.myFile);
        this.myCompactionMode = true;
    }

    public static PersistentHashMapValueStorage create(String path) throws IOException {
        return new PersistentHashMapValueStorage(path);
    }

    private static abstract class CacheValue<T> {
        private final T myFileAccessor;
        private final AtomicInteger myRefCount = new AtomicInteger(1);

        private CacheValue(T fileAccessor) {
            this.myFileAccessor = fileAccessor;
        }

        public final void allocate() {
            this.myRefCount.incrementAndGet();
        }

        public final void release() {
            if (this.myRefCount.decrementAndGet() == 0) {
                this.disposeAccessor(this.myFileAccessor);
            }
        }

        public T get() {
            return this.myFileAccessor;
        }

        protected abstract void disposeAccessor(T var1);
    }

    private static class CachedReader
    extends CacheValue<RAReader> {
        private CachedReader(RAReader reader) {
            super(reader);
        }

        @Override
        protected void disposeAccessor(RAReader reader) {
            reader.dispose();
        }
    }

    private static class CachedAppender
    extends CacheValue<DataOutputStream> {
        private CachedAppender(DataOutputStream os) {
            super(os);
        }

        @Override
        protected void disposeAccessor(DataOutputStream os) {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class FileAccessorCache<T>
    extends SLRUCache<String, CacheValue<T>> {
        private final Object myLock = new Object();

        private FileAccessorCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public final CacheValue<T> get(String key) {
            Object object = this.myLock;
            // MONITORENTER : object
            CacheValue value = (CacheValue)super.get(key);
            value.allocate();
            CacheValue cacheValue = value;
            // MONITOREXIT : object
            if (cacheValue != null) return cacheValue;
            throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMapValueStorage$FileAccessorCache.get must not return null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheValue<T> getIfCached(String key) {
            Object object = this.myLock;
            synchronized (object) {
                CacheValue value = (CacheValue)super.getIfCached(key);
                if (value != null) {
                    value.allocate();
                }
                return value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(String key) {
            Object object = this.myLock;
            synchronized (object) {
                return super.remove(key);
            }
        }

        @Override
        protected final void onDropFromCache(String key, CacheValue<T> value) {
            value.release();
        }
    }

    private static class FileReader
    implements RAReader {
        private final RandomAccessFile myFile;

        private FileReader(File file) {
            try {
                this.myFile = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void get(long addr, byte[] dst, int off, int len) throws IOException {
            this.myFile.seek(addr);
            this.myFile.read(dst, off, len);
        }

        @Override
        public void dispose() {
            try {
                this.myFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface RAReader {
        public void get(long var1, byte[] var3, int var4, int var5) throws IOException;

        public void dispose();
    }

    public static class ReadResult {
        public final long offset;
        public final byte[] buffer;

        public ReadResult(long offset, byte[] buffer) {
            this.offset = offset;
            this.buffer = buffer;
        }
    }
}

