/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileFilter;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.internal.com.intellij.util.CommonProcessors;
import org.jetbrains.jet.internal.com.intellij.util.Processor;
import org.jetbrains.jet.internal.com.intellij.util.containers.LimitedPool;
import org.jetbrains.jet.internal.com.intellij.util.containers.SLRUCache;
import org.jetbrains.jet.internal.com.intellij.util.io.DataExternalizer;
import org.jetbrains.jet.internal.com.intellij.util.io.DataOutputStream;
import org.jetbrains.jet.internal.com.intellij.util.io.IOStatistics;
import org.jetbrains.jet.internal.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.jet.internal.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentEnumerator;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentEnumeratorDelegate;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentHashMapValueStorage;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentMap;
import org.jetbrains.jet.internal.com.intellij.util.io.UnsyncByteArrayInputStream;
import org.jetbrains.jet.internal.com.intellij.util.io.UnsyncByteArrayOutputStream;

public class PersistentHashMap<Key, Value>
extends PersistentEnumeratorDelegate<Key>
implements PersistentMap<Key, Value> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.PersistentHashMap");
    private PersistentHashMapValueStorage myValueStorage;
    protected final DataExternalizer<Value> myValueExternalizer;
    private static final int INITIAL_INDEX_SIZE;
    @NonNls
    public static final String DATA_FILE_EXTENSION = ".values";
    private long myLiveAndGarbageKeysCounter;
    private int myReadCompactionGarbageSize;
    private final int myParentValueRefOffset;
    @NotNull
    private final byte[] myRecordBuffer;
    @NotNull
    private final byte[] mySmallRecordBuffer;
    private final boolean myCanReEnumerate;
    private int myLargeIndexWatermarkId;
    private boolean myIntAddressForNewRecord;
    private final LimitedPool<AppendStream> myStreamPool;
    private final SLRUCache<Key, AppendStream> myAppendCache;
    private final LowMemoryWatcher myAppendCacheFlusher;
    private int smallKeys;
    private int largeKeys;
    private int transformedKeys;
    private int requests;

    private boolean canUseIntAddressForNewRecord(long size) {
        return this.myCanReEnumerate ? size + 1L < Integer.MAX_VALUE : false;
    }

    public PersistentHashMap(@NotNull File file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.<init> must not be null");
        }
        if (keyDescriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.<init> must not be null");
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.<init> must not be null");
        }
        this(file, keyDescriptor, valueExternalizer, INITIAL_INDEX_SIZE);
    }

    public PersistentHashMap(@NotNull File file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.<init> must not be null");
        }
        if (keyDescriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.<init> must not be null");
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.<init> must not be null");
        }
        super(PersistentHashMap.checkDataFiles(file), keyDescriptor, initialSize);
        this.myStreamPool = new LimitedPool<AppendStream>(10, new LimitedPool.ObjectFactory<AppendStream>(){

            @Override
            @NotNull
            public AppendStream create() {
                AppendStream appendStream = new AppendStream();
                if (appendStream == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMap$1.create must not return null");
                }
                return appendStream;
            }

            @Override
            public void cleanup(@NotNull AppendStream appendStream) {
                if (appendStream == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentHashMap$1.cleanup must not be null");
                }
                appendStream.reset();
            }
        });
        this.myAppendCache = new SLRUCache<Key, AppendStream>(16384, 4096){

            @Override
            @NotNull
            public AppendStream createValue(Key key) {
                AppendStream appendStream = (AppendStream)PersistentHashMap.this.myStreamPool.alloc();
                if (appendStream == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMap$2.createValue must not return null");
                }
                return appendStream;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onDropFromCache(Key key, @NotNull AppendStream value) {
                if (value == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/io/PersistentHashMap$2.onDropFromCache must not be null");
                }
                PagedFileStorage.StorageLock storageLock = PersistentEnumerator.ourLock;
                synchronized (storageLock) {
                    try {
                        BufferExposingByteArrayOutputStream bytes = value.getInternalBuffer();
                        int id = PersistentHashMap.this.enumerate(key);
                        long oldHeaderRecord = PersistentHashMap.this.readValueId(id);
                        long headerRecord = PersistentHashMap.this.myValueStorage.appendBytes(bytes.getInternalBuffer(), 0, bytes.size(), oldHeaderRecord);
                        PersistentHashMap.this.updateValueId(id, headerRecord, oldHeaderRecord, key, 0);
                        if (oldHeaderRecord == 0L) {
                            PersistentHashMap.this.myLiveAndGarbageKeysCounter += 0x100000000L;
                        }
                        PersistentHashMap.this.myStreamPool.recycle(value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        this.myAppendCacheFlusher = LowMemoryWatcher.register(new LowMemoryWatcher.ForceableAdapter(){

            @Override
            public void force() {
                PersistentHashMap.this.dropMemoryCaches();
            }
        });
        final PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase> recordHandler = this.myEnumerator.getRecordHandler();
        this.myParentValueRefOffset = recordHandler.getRecordBuffer(this.myEnumerator).length;
        this.myRecordBuffer = new byte[this.myParentValueRefOffset + 8];
        this.mySmallRecordBuffer = new byte[this.myParentValueRefOffset + 4];
        this.myEnumerator.setRecordHandler(new PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase>(){

            @Override
            int recordWriteOffset(PersistentEnumeratorBase enumerator, byte[] buf) {
                return recordHandler.recordWriteOffset(enumerator, buf);
            }

            @Override
            @NotNull
            byte[] getRecordBuffer(PersistentEnumeratorBase enumerator) {
                byte[] byArray = PersistentHashMap.this.myIntAddressForNewRecord ? PersistentHashMap.this.mySmallRecordBuffer : PersistentHashMap.this.myRecordBuffer;
                if (byArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMap$4.getRecordBuffer must not return null");
                }
                return byArray;
            }

            @Override
            void setupRecord(PersistentEnumeratorBase enumerator, int hashCode, int dataOffset, @NotNull byte[] buf) {
                if (buf == null) {
                    throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/util/io/PersistentHashMap$4.setupRecord must not be null");
                }
                recordHandler.setupRecord(enumerator, hashCode, dataOffset, buf);
                for (int i = PersistentHashMap.this.myParentValueRefOffset; i < buf.length; ++i) {
                    buf[i] = 0;
                }
            }
        });
        this.myEnumerator.setMarkCleanCallback(new Flushable(){

            @Override
            public void flush() throws IOException {
                PersistentHashMap.this.myEnumerator.putMetaData(PersistentHashMap.this.myLiveAndGarbageKeysCounter);
                PersistentHashMap.this.myEnumerator.putMetaData2((long)PersistentHashMap.this.myLargeIndexWatermarkId | (long)PersistentHashMap.this.myReadCompactionGarbageSize << 32);
            }
        });
        try {
            this.myValueExternalizer = valueExternalizer;
            this.myValueStorage = PersistentHashMapValueStorage.create(PersistentHashMap.getDataFile(file).getPath());
            this.myLiveAndGarbageKeysCounter = this.myEnumerator.getMetaData();
            long data2 = this.myEnumerator.getMetaData2();
            this.myLargeIndexWatermarkId = (int)(data2 & 0xFFFFFFFFFFFFFFFFL);
            this.myReadCompactionGarbageSize = (int)(data2 >>> 32);
            this.myCanReEnumerate = this.myEnumerator.canReEnumerate();
            if (this.makesSenseToCompact()) {
                this.compact();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.error(t);
            throw new PersistentEnumeratorBase.CorruptedException(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropMemoryCaches() {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            PagedFileStorage.StorageLock storageLock = PersistentEnumerator.ourLock;
            synchronized (storageLock) {
                this.clearAppenderCaches();
            }
        }
    }

    public int getGarbageSize() {
        return (int)this.myLiveAndGarbageKeysCounter;
    }

    public File getBaseFile() {
        return this.myEnumerator.myFile;
    }

    private boolean makesSenseToCompact() {
        long fileSize = PersistentHashMap.getDataFile(this.myEnumerator.myFile).length();
        int megabyte = 0x100000;
        if (fileSize > 0x500000L) {
            int liveKeys = (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L);
            int deadKeys = (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL);
            if (deadKeys < 50) {
                return false;
            }
            int benefitSize = 0x6400000;
            long avgValueSize = fileSize / (long)(liveKeys + deadKeys);
            return deadKeys > liveKeys || avgValueSize * (long)deadKeys > 0x6400000L || (long)this.myReadCompactionGarbageSize > fileSize / 2L;
        }
        return false;
    }

    @NotNull
    private static File checkDataFiles(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.checkDataFiles must not be null");
        }
        if (!file.exists()) {
            PersistentHashMap.deleteFilesStartingWith(PersistentHashMap.getDataFile(file));
        }
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMap.checkDataFiles must not return null");
        }
        return file2;
    }

    public static void deleteFilesStartingWith(@NotNull File prefixFile) {
        if (prefixFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.deleteFilesStartingWith must not be null");
        }
        final String baseName = prefixFile.getName();
        File[] files = prefixFile.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(@NotNull File pathName) {
                if (pathName == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentHashMap$6.accept must not be null");
                }
                return pathName.getName().startsWith(baseName);
            }
        });
        if (files != null) {
            for (File f : files) {
                FileUtil.delete(f);
            }
        }
    }

    @NotNull
    private static File getDataFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.getDataFile must not be null");
        }
        File file2 = new File(file.getParentFile(), file.getName() + DATA_FILE_EXTENSION);
        if (file2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMap.getDataFile must not return null");
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(Key key, Value value) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doPut(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(Key key, Value value) throws IOException {
        PagedFileStorage.StorageLock storageLock = PersistentEnumerator.ourLock;
        synchronized (storageLock) {
            this.myEnumerator.markDirty(true);
            this.myAppendCache.remove(key);
            AppendStream record = new AppendStream();
            this.myValueExternalizer.save(record, value);
            BufferExposingByteArrayOutputStream bytes = record.getInternalBuffer();
            int id = this.enumerate(key);
            long oldheader = this.readValueId(id);
            this.myLiveAndGarbageKeysCounter = oldheader != 0L ? ++this.myLiveAndGarbageKeysCounter : (this.myLiveAndGarbageKeysCounter += 0x100000000L);
            long header = this.myValueStorage.appendBytes(bytes.getInternalBuffer(), 0, bytes.size(), 0L);
            this.updateValueId(id, header, oldheader, key, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int enumerate(Key name) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myIntAddressForNewRecord = this.canUseIntAddressForNewRecord(this.myValueStorage.getSize());
            return super.enumerate(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        if (appender == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.appendData must not be null");
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doAppendData(key, appender);
        }
    }

    protected void doAppendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        if (appender == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/io/PersistentHashMap.doAppendData must not be null");
        }
        this.myEnumerator.markDirty(true);
        AppendStream stream = this.myAppendCache.get(key);
        appender.append(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean processKeys(Processor<Key> processor) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myAppendCache.clear();
            return this.myEnumerator.iterateData(processor);
        }
    }

    @NotNull
    public Collection<Key> getAllKeysWithExistingMapping() throws IOException {
        ArrayList values = new ArrayList();
        this.processKeysWithExistingMapping(new CommonProcessors.CollectProcessor(values));
        ArrayList arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMap.getAllKeysWithExistingMapping must not return null");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean processKeysWithExistingMapping(Processor<Key> processor) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myAppendCache.clear();
            return this.myEnumerator.processAllDataObject(processor, new PersistentEnumeratorBase.DataFilter(){

                @Override
                public boolean accept(int id) {
                    return PersistentHashMap.this.readValueId(id) != 0L;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Value get(Key key) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            return this.doGet(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected Value doGet(Key key) throws IOException {
        PagedFileStorage.StorageLock storageLock = PersistentEnumerator.ourLock;
        synchronized (storageLock) {
            this.myAppendCache.remove(key);
            int id = this.tryEnumerate(key);
            if (id == 0) {
                return null;
            }
            long oldHeader = this.readValueId(id);
            if (oldHeader == 0L) {
                return null;
            }
            PersistentHashMapValueStorage.ReadResult readResult = this.myValueStorage.readBytes(oldHeader);
            if (readResult.offset != oldHeader) {
                this.myEnumerator.markDirty(true);
                this.updateValueId(id, readResult.offset, oldHeader, key, 0);
                ++this.myLiveAndGarbageKeysCounter;
                this.myReadCompactionGarbageSize += readResult.buffer.length;
            }
            DataInputStream input = new DataInputStream(new UnsyncByteArrayInputStream(readResult.buffer));
            Value Value2 = this.myValueExternalizer.read(input);
            return Value2;
            finally {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsMapping(Key key) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            return this.doContainsMapping(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doContainsMapping(Key key) throws IOException {
        PagedFileStorage.StorageLock storageLock = PersistentEnumerator.ourLock;
        synchronized (storageLock) {
            this.myAppendCache.remove(key);
            int id = this.tryEnumerate(key);
            if (id == 0) {
                return false;
            }
            return this.readValueId(id) != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Key key) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doRemove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemove(Key key) throws IOException {
        PagedFileStorage.StorageLock storageLock = PersistentEnumerator.ourLock;
        synchronized (storageLock) {
            this.myAppendCache.remove(key);
            int id = this.tryEnumerate(key);
            if (id == 0) {
                return;
            }
            this.myEnumerator.markDirty(true);
            long record = this.readValueId(id);
            if (record != 0L) {
                ++this.myLiveAndGarbageKeysCounter;
            }
            this.updateValueId(id, 0L, record, key, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void markDirty() throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myEnumerator.markDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void force() {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doForce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForce() {
        PagedFileStorage.StorageLock storageLock = PersistentEnumerator.ourLock;
        synchronized (storageLock) {
            try {
                this.clearAppenderCaches();
            }
            finally {
                super.force();
            }
        }
    }

    private void clearAppenderCaches() {
        this.myAppendCache.clear();
        this.myValueStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        PagedFileStorage.StorageLock storageLock = PersistentEnumerator.ourLock;
        synchronized (storageLock) {
            try {
                this.myAppendCacheFlusher.stop();
                this.myAppendCache.clear();
                this.myValueStorage.dispose();
            }
            finally {
                super.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            long now = System.currentTimeMillis();
            String newPath = PersistentHashMap.getDataFile(this.myEnumerator.myFile).getPath() + ".new";
            final PersistentHashMapValueStorage newStorage = PersistentHashMapValueStorage.create(newPath);
            this.myValueStorage.switchToCompactionMode();
            this.myLiveAndGarbageKeysCounter = 0L;
            this.myReadCompactionGarbageSize = 0;
            this.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                @Override
                public boolean process(int keyId) throws IOException {
                    long record = PersistentHashMap.this.readValueId(keyId);
                    if (record != 0L) {
                        PersistentHashMapValueStorage.ReadResult readResult = PersistentHashMap.this.myValueStorage.readBytes(record);
                        long value = newStorage.appendBytes(readResult.buffer, 0, readResult.buffer.length, 0L);
                        PersistentHashMap.this.updateValueId(keyId, value, record, null, this.getCurrentKey());
                        PersistentHashMap.this.myLiveAndGarbageKeysCounter += 0x100000000L;
                    }
                    return true;
                }
            });
            this.myValueStorage.dispose();
            newStorage.dispose();
            FileUtil.rename(new File(newPath), PersistentHashMap.getDataFile(this.myEnumerator.myFile));
            this.myValueStorage = PersistentHashMapValueStorage.create(PersistentHashMap.getDataFile(this.myEnumerator.myFile).getPath());
            LOG.info("Compacted " + this.myEnumerator.myFile.getPath() + " in " + (System.currentTimeMillis() - now) + "ms.");
            this.myEnumerator.putMetaData(this.myLiveAndGarbageKeysCounter);
        }
    }

    private long readValueId(int keyId) {
        long address = this.myEnumerator.myStorage.getInt(keyId + this.myParentValueRefOffset);
        if (address == 0L || address == -1L) {
            return 0L;
        }
        if (address < 0L) {
            address = -address - 1L;
        } else {
            int value = this.myEnumerator.myStorage.getInt(keyId + this.myParentValueRefOffset + 4);
            address = (address << 32) + (long)value & 0xBFFFFFFFFFFFFFFFL;
        }
        return address;
    }

    private int updateValueId(int keyId, long value, long oldValue, @Nullable Key key, int processingKey) throws IOException {
        boolean newKey;
        boolean bl = newKey = oldValue == 0L;
        if (newKey) {
            ++this.requests;
        }
        boolean defaultSizeInfo = true;
        if (this.myCanReEnumerate) {
            if (this.canUseIntAddressForNewRecord(value)) {
                defaultSizeInfo = false;
                this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset, -((int)(value + 1L)));
                if (newKey) {
                    ++this.smallKeys;
                }
            } else {
                if (newKey && this.myLargeIndexWatermarkId == 0) {
                    this.myLargeIndexWatermarkId = keyId;
                }
                if (keyId < this.myLargeIndexWatermarkId && (oldValue == 0L || this.canUseIntAddressForNewRecord(oldValue))) {
                    this.myIntAddressForNewRecord = false;
                    keyId = this.myEnumerator.reenumerate(key == null ? this.myEnumerator.getValue(keyId, processingKey) : key);
                    ++this.transformedKeys;
                }
            }
        }
        if (defaultSizeInfo) {
            this.myEnumerator.myStorage.putLong(keyId + this.myParentValueRefOffset, value | 0x4000000000000000L);
            if (newKey) {
                ++this.largeKeys;
            }
        }
        if (newKey && this.requests % 50000 == 0 && IOStatistics.DEBUG) {
            IOStatistics.dump("small:" + this.smallKeys + ", large:" + this.largeKeys + ", transformed:" + this.transformedKeys + ",@" + this.getBaseFile().getPath());
        }
        return keyId;
    }

    static {
        String property = System.getProperty("idea.initialIndexSize");
        INITIAL_INDEX_SIZE = property == null ? 4096 : Integer.valueOf(property);
    }

    public static interface ValueDataAppender {
        public void append(DataOutput var1) throws IOException;
    }

    private static class AppendStream
    extends DataOutputStream {
        private AppendStream() {
            super(new BufferExposingByteArrayOutputStream());
        }

        private void reset() {
            ((UnsyncByteArrayOutputStream)this.out).reset();
        }

        @NotNull
        private BufferExposingByteArrayOutputStream getInternalBuffer() {
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)this.out;
            if (bufferExposingByteArrayOutputStream == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMap$AppendStream.getInternalBuffer must not return null");
            }
            return bufferExposingByteArrayOutputStream;
        }
    }
}

