/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.Forceable;
import org.jetbrains.jet.internal.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentBTreeEnumerator;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentEnumerator;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentEnumeratorBase;

public class PersistentEnumeratorDelegate<Data>
implements Closeable,
Forceable {
    @NotNull
    protected final PersistentEnumeratorBase<Data> myEnumerator;

    public PersistentEnumeratorDelegate(@NotNull File file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentEnumeratorDelegate.<init> must not be null");
        }
        if (dataDescriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/io/PersistentEnumeratorDelegate.<init> must not be null");
        }
        this.myEnumerator = PersistentEnumeratorDelegate.useBtree() ? new PersistentBTreeEnumerator<Data>(file, dataDescriptor, initialSize) : new PersistentEnumerator<Data>(file, dataDescriptor, initialSize);
    }

    static boolean useBtree() {
        String property = System.getProperty("idea.use.btree");
        return !"false".equals(property);
    }

    @Override
    public void close() throws IOException {
        this.myEnumerator.close();
    }

    public boolean isClosed() {
        return this.myEnumerator.isClosed();
    }

    @Override
    public boolean isDirty() {
        return this.myEnumerator.isDirty();
    }

    @Override
    public void force() {
        this.myEnumerator.force();
    }

    public Data valueOf(int id) throws IOException {
        return this.myEnumerator.valueOf(id);
    }

    public int enumerate(Data name) throws IOException {
        return this.myEnumerator.enumerate(name);
    }

    public int tryEnumerate(Data name) throws IOException {
        return this.myEnumerator.tryEnumerate(name);
    }

    public boolean traverseAllRecords(PersistentEnumeratorBase.RecordsProcessor recordsProcessor) throws IOException {
        return this.myEnumerator.traverseAllRecords(recordsProcessor);
    }

    public Collection<Data> getAllDataObjects(@Nullable PersistentEnumeratorBase.DataFilter filter) throws IOException {
        return this.myEnumerator.getAllDataObjects(filter);
    }
}

