/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.Forceable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.jet.internal.com.intellij.util.containers.hash.LinkedHashMap;
import org.jetbrains.jet.internal.com.intellij.util.io.Bits;
import org.jetbrains.jet.internal.com.intellij.util.io.ByteBufferWrapper;
import org.jetbrains.jet.internal.com.intellij.util.io.IOStatistics;
import org.jetbrains.jet.internal.com.intellij.util.io.MappingFailedException;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentEnumeratorDelegate;
import sun.misc.VM;

public class PagedFileStorage
implements Forceable {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.PagedFileStorage");
    private static final int LOWER_LIMIT;
    private static final int UPPER_LIMIT;
    public static final int BUFFER_SIZE;
    private final StorageLock myLock;
    private int myLastPage = -1;
    private int myLastPage2 = -1;
    private ByteBufferWrapper myLastBuffer;
    private ByteBufferWrapper myLastBuffer2;
    private int myLastChangeCount;
    private int myLastChangeCount2;
    private int myStorageIndex;
    private final byte[] myTypedIOBuffer;
    private boolean isDirty = false;
    private final File myFile;
    protected long mySize = -1L;
    protected final int myPageSize;
    protected final boolean myValuesAreBufferAligned;

    public PagedFileStorage(File file, StorageLock lock, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        this.myFile = file;
        this.myLock = lock;
        this.myPageSize = Math.max(pageSize > 0 ? pageSize : BUFFER_SIZE, 4096);
        this.myValuesAreBufferAligned = valuesAreBufferAligned;
        this.myStorageIndex = lock.registerPagedFileStorage(this);
        this.myTypedIOBuffer = valuesAreBufferAligned ? null : new byte[8];
    }

    public PagedFileStorage(File file, StorageLock lock) throws IOException {
        this(file, lock, BUFFER_SIZE, false);
    }

    public File getFile() {
        return this.myFile;
    }

    public void putInt(int addr, int value) {
        if (this.myValuesAreBufferAligned) {
            this.isDirty = true;
            int page = addr / this.myPageSize;
            int page_offset = addr % this.myPageSize;
            this.getBuffer(page).putInt(page_offset, value);
        } else {
            Bits.putInt(this.myTypedIOBuffer, 0, value);
            this.put(addr, this.myTypedIOBuffer, 0, 4);
        }
    }

    public int getInt(int addr) {
        if (this.myValuesAreBufferAligned) {
            int page = addr / this.myPageSize;
            int page_offset = addr % this.myPageSize;
            return this.getBuffer(page).getInt(page_offset);
        }
        this.get(addr, this.myTypedIOBuffer, 0, 4);
        return Bits.getInt(this.myTypedIOBuffer, 0);
    }

    public final void putShort(int addr, short value) {
        if (this.myValuesAreBufferAligned) {
            this.isDirty = true;
            int page = addr / this.myPageSize;
            int page_offset = addr % this.myPageSize;
            this.getBuffer(page).putShort(page_offset, value);
        } else {
            Bits.putShort(this.myTypedIOBuffer, 0, value);
            this.put(addr, this.myTypedIOBuffer, 0, 2);
        }
    }

    int getOffsetInPage(int addr) {
        return addr % this.myPageSize;
    }

    ByteBuffer getByteBuffer(int address) {
        return this.getBuffer(address / this.myPageSize);
    }

    public final short getShort(int addr) {
        if (this.myValuesAreBufferAligned) {
            int page = addr / this.myPageSize;
            int page_offset = addr % this.myPageSize;
            return this.getBuffer(page).getShort(page_offset);
        }
        this.get(addr, this.myTypedIOBuffer, 0, 2);
        return Bits.getShort(this.myTypedIOBuffer, 0);
    }

    public void putLong(int addr, long value) {
        if (this.myValuesAreBufferAligned) {
            this.isDirty = true;
            int page = addr / this.myPageSize;
            int page_offset = addr % this.myPageSize;
            this.getBuffer(page).putLong(page_offset, value);
        } else {
            Bits.putLong(this.myTypedIOBuffer, 0, value);
            this.put(addr, this.myTypedIOBuffer, 0, 8);
        }
    }

    public void putByte(int addr, byte b) {
        this.put(addr, b);
    }

    public byte getByte(int addr) {
        return this.get(addr);
    }

    public long getLong(int addr) {
        if (this.myValuesAreBufferAligned) {
            int page = addr / this.myPageSize;
            int page_offset = addr % this.myPageSize;
            return this.getBuffer(page).getLong(page_offset);
        }
        this.get(addr, this.myTypedIOBuffer, 0, 8);
        return Bits.getLong(this.myTypedIOBuffer, 0);
    }

    public byte get(int index) {
        int page = index / this.myPageSize;
        int offset = index % this.myPageSize;
        return this.getBuffer(page).get(offset);
    }

    public void put(int index, byte value) {
        this.isDirty = true;
        int page = index / this.myPageSize;
        int offset = index % this.myPageSize;
        this.getBuffer(page).put(offset, value);
    }

    public void get(int index, byte[] dst, int offset, int length) {
        int i = index;
        int o = offset;
        int l = length;
        while (l > 0) {
            int page = i / this.myPageSize;
            int page_offset = i % this.myPageSize;
            int page_len = Math.min(l, this.myPageSize - page_offset);
            ByteBuffer buffer = this.getBuffer(page);
            try {
                buffer.position(page_offset);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("can't position buffer to offset " + page_offset + ", " + "buffer.limit=" + buffer.limit() + ", " + "page=" + page + ", " + "file=" + this.myFile.getName() + ", " + "file.length=" + this.mySize);
            }
            buffer.get(dst, o, page_len);
            l -= page_len;
            o += page_len;
            i += page_len;
        }
    }

    public void put(int index, byte[] src, int offset, int length) {
        this.isDirty = true;
        int i = index;
        int o = offset;
        int l = length;
        while (l > 0) {
            int page = i / this.myPageSize;
            int page_offset = i % this.myPageSize;
            int page_len = Math.min(l, this.myPageSize - page_offset);
            ByteBuffer buffer = this.getBuffer(page);
            try {
                buffer.position(page_offset);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("can't position buffer to offset " + page_offset);
            }
            buffer.put(src, o, page_len);
            l -= page_len;
            o += page_len;
            i += page_len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.force();
        }
        finally {
            this.unmapAll();
            this.myLock.myIndex2Storage.remove(this.myStorageIndex);
            this.myStorageIndex = -1;
        }
    }

    private void unmapAll() {
        this.myLock.myBuffersCache.unmapBuffersForOwner(this.myStorageIndex);
        this.myLastPage = -1;
        this.myLastPage2 = -1;
        this.myLastBuffer = null;
        this.myLastBuffer2 = null;
    }

    public void resize(int newSize) throws IOException {
        long finished;
        int oldSize = (int)this.myFile.length();
        if (oldSize == newSize) {
            return;
        }
        long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        this.unmapAll();
        long unmapAllFinished = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        this.resizeFile(newSize);
        int delta = newSize - oldSize;
        if (delta > 0) {
            this.fillWithZeros(oldSize, delta);
        }
        if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
            IOStatistics.dump("Resized " + this.myFile + " from " + oldSize + " to " + newSize + " for " + (finished - started) + ", unmap all:" + (finished - unmapAllFinished));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeFile(int newSize) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.myFile, "rw");
        try {
            raf.setLength(newSize);
        }
        finally {
            raf.close();
        }
        this.mySize = newSize;
    }

    private void fillWithZeros(int from, int length) {
        byte[] buff = new byte[8192];
        Arrays.fill(buff, (byte)0);
        while (length > 0) {
            int filled = Math.min(length, 8192);
            this.put(from, buff, 0, filled);
            length -= filled;
            from += filled;
        }
    }

    public final long length() {
        if (this.mySize == -1L) {
            this.mySize = this.myFile.length();
        }
        return this.mySize;
    }

    private ByteBuffer getBuffer(int page) {
        ByteBuffer buf;
        if (this.myLastPage == page && (buf = this.myLastBuffer.getCachedBuffer()) != null && this.myLastChangeCount == this.myLock.myBuffersCache.changeCount) {
            return buf;
        }
        if (this.myLastPage2 == page && (buf = this.myLastBuffer2.getCachedBuffer()) != null && this.myLastChangeCount2 == this.myLock.myBuffersCache.changeCount) {
            return buf;
        }
        try {
            assert (page <= 65535);
            if (this.myStorageIndex == -1) {
                this.myStorageIndex = this.myLock.registerPagedFileStorage(this);
            }
            ByteBufferWrapper byteBufferWrapper = this.myLock.myBuffersCache.get(this.myStorageIndex | page);
            ByteBuffer buf2 = byteBufferWrapper.getBuffer();
            if (this.myLastPage != page) {
                this.myLastPage2 = this.myLastPage;
                this.myLastBuffer2 = this.myLastBuffer;
                this.myLastChangeCount2 = this.myLastChangeCount;
                this.myLastBuffer = byteBufferWrapper;
                this.myLastPage = page;
            } else {
                this.myLastBuffer = byteBufferWrapper;
            }
            this.myLastChangeCount = this.myLock.myBuffersCache.changeCount;
            return buf2;
        }
        catch (IOException e) {
            throw new MappingFailedException("Cannot map buffer", e);
        }
    }

    @Override
    public void force() {
        long finished;
        long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        this.myLock.myBuffersCache.flushBuffersForOwner(this.myStorageIndex);
        this.isDirty = false;
        if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
            IOStatistics.dump("Flushed " + this.myFile + " for " + (finished - started));
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    static /* synthetic */ int access$100() {
        return UPPER_LIMIT;
    }

    static {
        int lower = 100;
        int upper = SystemInfo.is64Bit && !PersistentEnumeratorDelegate.useBtree() ? 500 : 200;
        BUFFER_SIZE = Math.max(1, SystemInfo.getIntProperty("idea.paged.storage.page.size", 10)) * 0x100000;
        if (ByteBufferWrapper.NO_MMAP) {
            long max = VM.maxDirectMemory() - (long)(2 * BUFFER_SIZE);
            LOWER_LIMIT = (int)Math.min(0x6400000L, max);
            UPPER_LIMIT = (int)Math.min((long)Math.max(LOWER_LIMIT, SystemInfo.getIntProperty("idea.max.paged.storage.cache", upper) * 0x100000), max);
        } else {
            LOWER_LIMIT = 0x6400000;
            UPPER_LIMIT = Math.max(LOWER_LIMIT, SystemInfo.getIntProperty("idea.max.paged.storage.cache", upper) * 0x100000);
        }
        LOG.info("lower=" + LOWER_LIMIT / 0x100000 + "; upper=" + UPPER_LIMIT / 0x100000 + "; buffer=" + BUFFER_SIZE / 0x100000 + "; mmap=" + !ByteBufferWrapper.NO_MMAP);
    }

    public static class StorageLock {
        private final boolean checkThreadAccess;
        private final BuffersCache myBuffersCache = new BuffersCache();
        private final ConcurrentHashMap<Integer, PagedFileStorage> myIndex2Storage = new ConcurrentHashMap();

        public StorageLock() {
            this(true);
        }

        public StorageLock(boolean checkThreadAccess) {
            this.checkThreadAccess = checkThreadAccess;
        }

        private int registerPagedFileStorage(PagedFileStorage storage) {
            int registered = this.myIndex2Storage.size();
            assert (registered <= 65535);
            int value = registered << 16;
            while (this.myIndex2Storage.putIfAbsent(value, storage) != null) {
                assert (++registered <= 65535);
                value = registered << 16;
            }
            return value;
        }

        private PagedFileStorage getRegisteredPagedFileStorageByIndex(int index) {
            return this.myIndex2Storage.get(index);
        }

        private class BuffersCache {
            private int changeCount;
            private final LinkedHashMap<Integer, ByteBufferWrapper> myMap;
            private long mySizeLimit = PagedFileStorage.access$100();
            private long mySize;

            private BuffersCache() {
                this.myMap = new LinkedHashMap<Integer, ByteBufferWrapper>(10){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Integer, ByteBufferWrapper> eldest) {
                        return BuffersCache.this.mySize > BuffersCache.this.mySizeLimit;
                    }

                    @Override
                    @Nullable
                    public ByteBufferWrapper remove(Object key) {
                        ByteBufferWrapper wrapper = (ByteBufferWrapper)super.remove(key);
                        if (wrapper != null) {
                            BuffersCache.this.mySize -= wrapper.myLength;
                            wrapper.dispose();
                        }
                        return wrapper;
                    }
                };
            }

            private ByteBufferWrapper get(Integer key) {
                long finished;
                ByteBufferWrapper wrapper = this.myMap.get(key);
                if (wrapper != null) {
                    return wrapper;
                }
                long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
                wrapper = this.createValue(key);
                this.mySize += wrapper.myLength;
                if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
                    IOStatistics.dump("Mapping " + wrapper.myLength + " from " + wrapper.myPosition + " file:" + wrapper.myFile + " for " + (finished - started));
                }
                this.myMap.put(key, wrapper);
                this.ensureSize(this.mySizeLimit);
                return wrapper;
            }

            private void ensureSize(long sizeLimit) {
                while (this.mySize > sizeLimit) {
                    this.myMap.doRemoveEldestEntry();
                }
            }

            @NotNull
            private ByteBufferWrapper createValue(Integer key) {
                this.checkThreadAccess();
                int storageIndex = key & 0xFFFF0000;
                PagedFileStorage owner = StorageLock.this.getRegisteredPagedFileStorageByIndex(storageIndex);
                assert (owner != null) : "No storage for index " + storageIndex;
                int off = (key & 0xFFFF) * owner.myPageSize;
                if ((long)off > owner.length()) {
                    throw new IndexOutOfBoundsException("off=" + off + " key.owner.length()=" + owner.length());
                }
                ++this.changeCount;
                ByteBufferWrapper wrapper = ByteBufferWrapper.readWrite(owner.myFile, off, Math.min((int)(owner.length() - (long)off), owner.myPageSize));
                IOException oome = null;
                while (true) {
                    ByteBufferWrapper byteBufferWrapper;
                    try {
                        wrapper.getBuffer();
                        if (oome != null) {
                            LOG.info("Successfully recovered OOME in memory mapping: -Xmx=" + Runtime.getRuntime().maxMemory() / 0x100000L + "MB " + "new size limit: " + this.mySizeLimit / 0x100000L + "MB " + "trying to allocate " + wrapper.myLength + " block");
                        }
                        byteBufferWrapper = wrapper;
                    }
                    catch (IOException e) {
                        if (e.getCause() instanceof OutOfMemoryError) {
                            long newSize;
                            oome = e;
                            if (this.mySizeLimit > (long)LOWER_LIMIT) {
                                this.mySizeLimit -= (long)owner.myPageSize;
                            }
                            if ((newSize = this.mySize - (long)owner.myPageSize) >= 0L) {
                                this.ensureSize(newSize);
                                continue;
                            }
                            throw new MappingFailedException("Cannot recover from OOME in memory mapping: -Xmx=" + Runtime.getRuntime().maxMemory() / 0x100000L + "MB " + "new size limit: " + this.mySizeLimit / 0x100000L + "MB " + "trying to allocate " + wrapper.myLength + " block", e);
                        }
                        throw new MappingFailedException("Cannot map buffer", e);
                    }
                    if (byteBufferWrapper == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/util/io/PagedFileStorage$StorageLock$BuffersCache.createValue must not return null");
                    }
                    return byteBufferWrapper;
                }
            }

            private void checkThreadAccess() {
                if (StorageLock.this.checkThreadAccess && !Thread.holdsLock(StorageLock.this)) {
                    throw new IllegalStateException("Must hold StorageLock lock to access PagedFileStorage");
                }
            }

            @Nullable
            private Map<Integer, ByteBufferWrapper> getBuffersOrderedForOwner(int index) {
                this.checkThreadAccess();
                TreeMap<Integer, ByteBufferWrapper> mineBuffers = null;
                for (Map.Entry<Integer, ByteBufferWrapper> entry : this.myMap.entrySet()) {
                    if ((entry.getKey() & 0xFFFF0000) != index) continue;
                    if (mineBuffers == null) {
                        mineBuffers = new TreeMap<Integer, ByteBufferWrapper>(new Comparator<Integer>(){

                            @Override
                            public int compare(Integer o1, Integer o2) {
                                return o1 - o2;
                            }
                        });
                    }
                    mineBuffers.put(entry.getKey(), entry.getValue());
                }
                return mineBuffers;
            }

            private void unmapBuffersForOwner(int index) {
                Map<Integer, ByteBufferWrapper> buffers = this.getBuffersOrderedForOwner(index);
                if (buffers != null) {
                    for (Integer key : buffers.keySet()) {
                        this.myMap.remove(key);
                    }
                }
            }

            private void flushBuffersForOwner(int index) {
                Map<Integer, ByteBufferWrapper> buffers = this.getBuffersOrderedForOwner(index);
                if (buffers != null) {
                    for (ByteBufferWrapper buffer : buffers.values()) {
                        buffer.flush();
                    }
                }
            }
        }
    }
}

