/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.util.concurrency.Semaphore;
import org.jetbrains.jet.internal.com.intellij.util.io.BaseOutputReader;

public abstract class OutputReader
extends BaseOutputReader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.OutputReader");
    private final Semaphore myReadFullySemaphore;

    public OutputReader(@NotNull Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/OutputReader.<init> must not be null");
        }
        super(reader);
        this.myReadFullySemaphore = new Semaphore();
        this.start();
    }

    @Override
    protected void doRun() {
        try {
            while (true) {
                boolean read;
                if (!(read = this.readAvailable())) {
                    this.myReadFullySemaphore.up();
                }
                if (this.isStopped) {
                    this.myReader.close();
                    break;
                }
                Thread.sleep(read ? 1L : 5L);
            }
        }
        catch (InterruptedException read) {
        }
        catch (IOException e) {
            LOG.info(e);
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    public void readFully() throws InterruptedException {
        this.myReadFullySemaphore.down();
        while (!this.myReadFullySemaphore.waitForUnsafe(10L)) {
            if (!this.isStopped) continue;
            this.waitFor();
            return;
        }
    }
}

