/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.util.io.DataExternalizer;

public class NullableDataExternalizer<T>
implements DataExternalizer<T> {
    private final DataExternalizer<T> myNotNullExternalizer;

    public NullableDataExternalizer(DataExternalizer<T> externalizer) {
        this.myNotNullExternalizer = externalizer;
    }

    @Override
    public void save(DataOutput out, T value) throws IOException {
        if (value == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.myNotNullExternalizer.save(out, value);
        }
    }

    @Override
    @Nullable
    public T read(DataInput in) throws IOException {
        boolean isDefined = in.readBoolean();
        if (isDefined) {
            return this.myNotNullExternalizer.read(in);
        }
        return null;
    }
}

