/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.internal.com.intellij.util.io.IOStatistics;
import org.jetbrains.jet.internal.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.jet.internal.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.jet.internal.com.intellij.util.io.ResizeableMappedFile;
import org.jetbrains.jet.internal.gnu.trove.TIntIntHashMap;

class IntToIntBtree {
    final int pageSize;
    private final short maxInteriorNodes;
    private final short maxLeafNodes;
    private final short maxLeafNodesInHash;
    final BtreeIndexNodeView root;
    private int height;
    private int maxStepsSearchedInHash;
    private int totalHashStepsSearched;
    private int hashSearchRequests;
    private int pagesCount;
    private int hashedPagesCount;
    private int count;
    private int movedMembersCount;
    private boolean isLarge = true;
    private final ResizeableMappedFile storage;
    private final boolean offloadToSiblingsBeforeSplit = false;
    private boolean indexNodeIsHashTable = true;
    final int metaDataLeafPageLength;
    final int hashPageCapacity;
    private TIntIntHashMap myCachedMappings;
    private final int myCachedMappingsSize;

    public IntToIntBtree(int _pageSize, File file, boolean initial) throws IOException {
        this.pageSize = _pageSize;
        if (initial) {
            FileUtil.delete(file);
        }
        this.storage = new ResizeableMappedFile(file, this.pageSize, PersistentEnumeratorBase.ourLock, 0x100000, true);
        this.root = new BtreeIndexNodeView(this);
        if (initial) {
            this.nextPage();
            this.root.setAddress(0);
            this.root.setIndexLeaf(true);
        }
        int i = (this.pageSize - 8) / 8 - 1;
        assert (i < Short.MAX_VALUE && i % 2 == 0);
        this.maxInteriorNodes = (short)i;
        this.maxLeafNodes = (short)i;
        int metaPageLen = 8;
        if (this.indexNodeIsHashTable) {
            ++i;
            double bitsPerState = 1.0;
            while (Math.ceil(1.0 * (double)i / 8.0) + (double)(i * 8) + 8.0 > (double)this.pageSize || !IntToIntBtree.isPrime(i)) {
                i -= 2;
            }
            this.hashPageCapacity = i;
            metaPageLen = 8 + (int)Math.ceil(1.0 * (double)this.hashPageCapacity / 8.0);
            i = (int)((double)this.hashPageCapacity * 0.8);
            if ((i & 1) == 1) {
                ++i;
            }
        } else {
            this.hashPageCapacity = -1;
        }
        this.metaDataLeafPageLength = metaPageLen;
        assert (i > 0 && i % 2 == 0);
        this.maxLeafNodesInHash = (short)i;
        this.myCachedMappings = null;
        this.myCachedMappingsSize = -1;
    }

    public void persistVars(BtreeDataStorage storage, boolean toDisk) {
        this.height = storage.persistInt(0, this.height, toDisk);
        this.pagesCount = storage.persistInt(4, this.pagesCount, toDisk);
        this.movedMembersCount = storage.persistInt(8, this.movedMembersCount, toDisk);
        this.maxStepsSearchedInHash = storage.persistInt(12, this.maxStepsSearchedInHash, toDisk);
        this.count = storage.persistInt(16, this.count, toDisk);
        this.hashSearchRequests = storage.persistInt(20, this.hashSearchRequests, toDisk);
        this.totalHashStepsSearched = storage.persistInt(24, this.totalHashStepsSearched, toDisk);
        this.hashedPagesCount = storage.persistInt(28, this.hashedPagesCount, toDisk);
        this.root.setAddress(storage.persistInt(32, this.root.address, toDisk));
    }

    private static boolean isPrime(int val) {
        if (val % 2 == 0) {
            return false;
        }
        int maxDivisor = (int)Math.sqrt(val);
        for (int i = 3; i <= maxDivisor; i += 2) {
            if (val % i != 0) continue;
            return false;
        }
        return true;
    }

    private int nextPage() {
        int pageStart = (int)this.storage.length();
        this.storage.putInt(pageStart + this.pageSize - 4, 0);
        ++this.pagesCount;
        return pageStart;
    }

    public boolean get(int key, int[] result) {
        BtreeIndexNodeView currentIndexNode = new BtreeIndexNodeView(this);
        currentIndexNode.setAddress(this.root.address);
        int index = currentIndexNode.locate(key, false);
        if (index < 0) {
            return false;
        }
        result[0] = currentIndexNode.addressAt(index);
        return true;
    }

    public void put(int key, int value) {
        this.doPut(key, value);
    }

    private void doPut(int key, int value) {
        BtreeIndexNodeView currentIndexNode = new BtreeIndexNodeView(this);
        currentIndexNode.setAddress(this.root.address);
        int index = currentIndexNode.locate(key, true);
        if (index < 0) {
            ++this.count;
            currentIndexNode.insert(key, value);
        } else {
            currentIndexNode.setAddressAt(index, value);
        }
    }

    void dumpStatistics() {
        int leafPages = this.height == 3 ? this.pagesCount - (1 + this.root.getChildrenCount() + 1) : (this.height == 2 ? this.pagesCount - 1 : 1);
        long leafNodesCapacity = this.hashedPagesCount * this.maxLeafNodesInHash + (leafPages - this.hashedPagesCount) * this.maxLeafNodes;
        long leafNodesCapacity2 = leafPages * this.maxLeafNodes;
        int usedPercent = (int)((long)this.count * 100L / leafNodesCapacity);
        int usedPercent2 = (int)((long)this.count * 100L / leafNodesCapacity2);
        IOStatistics.dump("pagecount:" + this.pagesCount + ", height:" + this.height + ", movedMembers:" + this.movedMembersCount + ", hash steps:" + this.maxStepsSearchedInHash + ", avg search in hash:" + (this.hashSearchRequests != 0 ? this.totalHashStepsSearched / this.hashSearchRequests : 0) + ", leaf pages used:" + usedPercent + "%, leaf pages used if sorted: " + usedPercent2 + "%, size:" + this.storage.length());
    }

    private void flushCachedMappings() {
    }

    void doClose() throws IOException {
        this.myCachedMappings = null;
        this.storage.close();
    }

    void doFlush() {
        this.flushCachedMappings();
        this.storage.force();
    }

    static void myAssert(boolean b) {
        if (!b) {
            IntToIntBtree.myAssert(true);
        }
        assert (b);
    }

    static class BtreeIndexNodeView
    extends BtreePage {
        private boolean isIndexLeaf;
        private boolean flagsSet;
        private boolean isHashedLeaf;

        BtreeIndexNodeView(IntToIntBtree btree) {
            super(btree);
        }

        @Override
        protected void syncWithStore() {
            super.syncWithStore();
            this.flagsSet = false;
        }

        int search(int value) {
            if (this.isIndexLeaf() && this.isHashedLeaf()) {
                return this.hashIndex(value);
            }
            int hi = this.getChildrenCount() - 1;
            int lo = 0;
            while (lo <= hi) {
                int mid = lo + (hi - lo) / 2;
                int keyAtMid = this.keyAt(mid);
                if (value > keyAtMid) {
                    lo = mid + 1;
                    continue;
                }
                if (value < keyAtMid) {
                    hi = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(lo + 1);
        }

        final int addressAt(int i) {
            return this.getInt(this.indexToOffset(i));
        }

        private void setAddressAt(int i, int value) {
            int offset = this.indexToOffset(i);
            this.putInt(offset, value);
        }

        private final int indexToOffset(int i) {
            return i * 8 + (this.isHashedLeaf() ? this.btree.metaDataLeafPageLength : 8);
        }

        private final int keyAt(int i) {
            return this.getInt(this.indexToOffset(i) + 4);
        }

        private void setKeyAt(int i, int value) {
            int offset = this.indexToOffset(i) + 4;
            this.putInt(offset, value);
        }

        final boolean isIndexLeaf() {
            if (!this.flagsSet) {
                this.initFlags();
            }
            return this.isIndexLeaf;
        }

        private void initFlags() {
            byte flags = this.myBuffer.get(this.myAddressInBuffer);
            this.isHashedLeaf = (flags & 2) == 2;
            this.isIndexLeaf = (flags & 1) == 1;
        }

        void setIndexLeaf(boolean value) {
            this.isIndexLeaf = value;
            this.setFlag(1, value);
        }

        private final boolean isHashedLeaf() {
            if (!this.flagsSet) {
                this.initFlags();
            }
            return this.isHashedLeaf;
        }

        void setHashedLeaf(boolean value) {
            this.isHashedLeaf = value;
            this.setFlag(2, value);
        }

        final short getMaxChildrenCount() {
            return this.isIndexLeaf() ? (this.isHashedLeaf() ? this.btree.maxLeafNodesInHash : this.btree.maxLeafNodes) : this.btree.maxInteriorNodes;
        }

        final boolean isFull() {
            short childrenCount = this.getChildrenCount();
            if (!this.isIndexLeaf()) {
                childrenCount = (short)(childrenCount + 1);
            }
            return childrenCount == this.getMaxChildrenCount();
        }

        int[] exportKeys() {
            assert (this.isIndexLeaf());
            int childrenCount = this.getChildrenCount();
            int[] keys = new int[childrenCount];
            if (this.isHashedLeaf()) {
                int offset = this.myAddressInBuffer + this.indexToOffset(0) + 4;
                int keyNumber = 0;
                for (int i = 0; i < this.btree.hashPageCapacity; ++i) {
                    if (this.hashGetState(i) != 1) continue;
                    int key = this.myBuffer.getInt(offset + i * 8);
                    keys[keyNumber++] = key;
                }
            } else {
                for (int i = 0; i < childrenCount; ++i) {
                    keys[i] = this.keyAt(i);
                }
            }
            return keys;
        }

        private int splitNode(int parentAddress) {
            boolean indexLeaf = this.isIndexLeaf();
            boolean hashedLeaf = this.isHashedLeaf();
            short recordCount = this.getChildrenCount();
            BtreeIndexNodeView parent = null;
            HashLeafData hashLeafData = null;
            if (parentAddress != 0) {
                parent = new BtreeIndexNodeView(this.btree);
                parent.setAddress(parentAddress);
            }
            short maxIndex = (short)(this.getMaxChildrenCount() / 2);
            BtreeIndexNodeView newIndexNode = new BtreeIndexNodeView(this.btree);
            newIndexNode.setAddress(this.btree.nextPage());
            this.syncWithStore();
            if (parent != null) {
                parent.syncWithStore();
            }
            this.btree.root.syncWithStore();
            newIndexNode.setIndexLeaf(indexLeaf);
            int nextPage = this.getNextPage();
            this.setNextPage(newIndexNode.address);
            newIndexNode.setNextPage(nextPage);
            int medianKey = -1;
            if (indexLeaf && hashedLeaf) {
                if (hashLeafData == null) {
                    hashLeafData = new HashLeafData(this, recordCount);
                }
                int[] keys = hashLeafData.keys;
                boolean defaultSplit = true;
                if (defaultSplit) {
                    hashLeafData.clean();
                    TIntIntHashMap map = hashLeafData.values;
                    int avg = keys.length / 2;
                    medianKey = keys[avg];
                    --this.btree.hashedPagesCount;
                    this.setChildrenCount((short)0);
                    newIndexNode.setChildrenCount((short)0);
                    for (int i = 0; i < avg; ++i) {
                        int key = keys[i];
                        this.insert(key, map.get(key));
                        key = keys[avg + i];
                        newIndexNode.insert(key, map.get(key));
                    }
                }
            } else {
                int recordCountInNewNode = recordCount - maxIndex;
                newIndexNode.setChildrenCount((short)recordCountInNewNode);
                if (this.btree.isLarge) {
                    ByteBuffer buffer = this.getBytes(this.indexToOffset(maxIndex), recordCountInNewNode * 8);
                    newIndexNode.putBytes(newIndexNode.indexToOffset(0), buffer);
                } else {
                    for (int i = 0; i < recordCountInNewNode; ++i) {
                        newIndexNode.setAddressAt(i, this.addressAt(i + maxIndex));
                        newIndexNode.setKeyAt(i, this.keyAt(i + maxIndex));
                    }
                }
                if (indexLeaf) {
                    medianKey = newIndexNode.keyAt(0);
                } else {
                    newIndexNode.setAddressAt(recordCountInNewNode, this.addressAt(recordCount));
                    maxIndex = (short)(maxIndex - 1);
                    medianKey = this.keyAt(maxIndex);
                }
                this.setChildrenCount(maxIndex);
            }
            if (parent != null) {
                parent.insert(medianKey, -newIndexNode.address);
            } else {
                int newRootAddress = this.btree.nextPage();
                newIndexNode.syncWithStore();
                this.syncWithStore();
                this.btree.root.setAddress(newRootAddress);
                parentAddress = newRootAddress;
                this.btree.root.setChildrenCount((short)1);
                this.btree.root.setKeyAt(0, medianKey);
                this.btree.root.setAddressAt(0, -this.address);
                this.btree.root.setAddressAt(1, -newIndexNode.address);
            }
            return parentAddress;
        }

        private int locate(int valueHC, boolean split) {
            int searched = 0;
            int parentAddress = 0;
            int maxHeight = this.btree.height + 1;
            while (true) {
                if (split && this.isFull()) {
                    if ((parentAddress = this.splitNode(parentAddress)) != 0) {
                        this.setAddress(parentAddress);
                    }
                    --searched;
                }
                int i = this.search(valueHC);
                if (++searched > maxHeight) {
                    throw new IllegalStateException();
                }
                if (this.isIndexLeaf()) {
                    this.btree.height = Math.max(this.btree.height, searched);
                    return i;
                }
                int address = i < 0 ? this.addressAt(-i - 1) : this.addressAt(i + 1);
                parentAddress = this.address;
                this.setAddress(-address);
            }
        }

        private void insert(int valueHC, int newValueId) {
            short recordCount = this.getChildrenCount();
            boolean indexLeaf = this.isIndexLeaf();
            if (indexLeaf) {
                if (recordCount == 0 && this.btree.indexNodeIsHashTable) {
                    this.setHashedLeaf(true);
                    ++this.btree.hashedPagesCount;
                }
                if (this.isHashedLeaf()) {
                    int index = this.hashInsertionIndex(valueHC);
                    if (index < 0) {
                        index = -index - 1;
                    }
                    this.setKeyAt(index, valueHC);
                    this.hashSetState(index, 1);
                    this.setAddressAt(index, newValueId);
                    this.setChildrenCount((short)(recordCount + 1));
                    return;
                }
            }
            int medianKeyInParent = this.search(valueHC);
            int index = -medianKeyInParent - 1;
            this.setChildrenCount((short)(recordCount + 1));
            int itemsToMove = recordCount - index;
            this.btree.movedMembersCount += itemsToMove;
            if (indexLeaf) {
                if (this.btree.isLarge && itemsToMove > 5) {
                    ByteBuffer buffer = this.getBytes(this.indexToOffset(index), itemsToMove * 8);
                    this.putBytes(this.indexToOffset(index + 1), buffer);
                } else {
                    for (int i = recordCount - 1; i >= index; --i) {
                        this.setKeyAt(i + 1, this.keyAt(i));
                        this.setAddressAt(i + 1, this.addressAt(i));
                    }
                }
                this.setKeyAt(index, valueHC);
                this.setAddressAt(index, newValueId);
            } else {
                this.setAddressAt(recordCount + 1, this.addressAt(recordCount));
                if (this.btree.isLarge && itemsToMove > 5) {
                    int elementsAfterIndex = recordCount - index - 1;
                    if (elementsAfterIndex > 0) {
                        ByteBuffer buffer = this.getBytes(this.indexToOffset(index + 1), elementsAfterIndex * 8);
                        this.putBytes(this.indexToOffset(index + 2), buffer);
                    }
                } else {
                    for (int i = recordCount - 1; i > index; --i) {
                        this.setKeyAt(i + 1, this.keyAt(i));
                        this.setAddressAt(i + 1, this.addressAt(i));
                    }
                }
                if (index < recordCount) {
                    this.setKeyAt(index + 1, this.keyAt(index));
                }
                this.setKeyAt(index, valueHC);
                this.setAddressAt(index + 1, newValueId);
            }
        }

        private int hashIndex(int value) {
            int length = this.btree.hashPageCapacity;
            int hash = this.hash(value) & Integer.MAX_VALUE;
            int index = hash % length;
            int state = this.hashGetState(index);
            int total = 0;
            this.btree.hashSearchRequests++;
            if (state != 0 && (state == 2 || this.keyAt(index) != value)) {
                int probe = 1 + hash % (length - 2);
                do {
                    if ((index -= probe) < 0) {
                        index += length;
                    }
                    state = this.hashGetState(index);
                    if (++total <= length) continue;
                    throw new IllegalStateException("Index corrupted");
                } while (state != 0 && (state == 2 || this.keyAt(index) != value));
            }
            this.btree.maxStepsSearchedInHash = Math.max(this.btree.maxStepsSearchedInHash, total);
            this.btree.totalHashStepsSearched += total;
            return state == 0 ? -1 : index;
        }

        protected int hashInsertionIndex(int val) {
            int length = this.btree.hashPageCapacity;
            int hash = this.hash(val) & Integer.MAX_VALUE;
            int index = hash % length;
            this.btree.hashSearchRequests++;
            int state = this.hashGetState(index);
            if (state == 0) {
                return index;
            }
            if (state == 1 && this.keyAt(index) == val) {
                return -index - 1;
            }
            int probe = 1 + hash % (length - 2);
            int total = 0;
            do {
                if ((index -= probe) < 0) {
                    index += length;
                }
                ++total;
            } while ((state = this.hashGetState(index)) == 1 && this.keyAt(index) != val);
            if (state == 2) {
                int firstRemoved = index;
                while (state != 0 && (state == 2 || this.keyAt(index) != val)) {
                    if ((index -= probe) < 0) {
                        index += length;
                    }
                    state = this.hashGetState(index);
                    ++total;
                }
                return state == 1 ? -index - 1 : firstRemoved;
            }
            this.btree.maxStepsSearchedInHash = Math.max(this.btree.maxStepsSearchedInHash, total);
            this.btree.totalHashStepsSearched += total;
            return state == 1 ? -index - 1 : index;
        }

        private final int hash(int val) {
            return val;
        }

        private final int hashGetState(int index) {
            byte b = this.myBuffer.get(this.hashOccupiedStatusByteOffset(index));
            return (b & 0xFF) >> this.hashOccupiedStatusShift(index) & 1;
        }

        private final int hashOccupiedStatusShift(int index) {
            return 7 - (index & 7);
        }

        private final int hashOccupiedStatusByteOffset(int index) {
            return this.myAddressInBuffer + 8 + (index >> 3);
        }

        private void hashSetState(int index, int value) {
            int hashOccupiedStatusOffset = this.hashOccupiedStatusByteOffset(index);
            byte b = this.myBuffer.get(hashOccupiedStatusOffset);
            int shift = this.hashOccupiedStatusShift(index);
            b = (byte)(b & 0xFF & ~(1 << shift) | value << shift);
            this.myBuffer.put(hashOccupiedStatusOffset, b);
        }

        static class HashLeafData {
            final BtreeIndexNodeView nodeView;
            final int[] keys;
            final TIntIntHashMap values;

            HashLeafData(BtreeIndexNodeView _nodeView, int recordCount) {
                this.nodeView = _nodeView;
                IntToIntBtree btree = _nodeView.btree;
                int offset = this.nodeView.myAddressInBuffer + this.nodeView.indexToOffset(0);
                ByteBuffer buffer = this.nodeView.myBuffer;
                this.keys = new int[recordCount];
                this.values = new TIntIntHashMap(recordCount);
                int keyNumber = 0;
                for (int i = 0; i < btree.hashPageCapacity; ++i) {
                    if (this.nodeView.hashGetState(i) != 1) continue;
                    int key = buffer.getInt(offset + i * 8 + 4);
                    this.keys[keyNumber++] = key;
                    int value = buffer.getInt(offset + i * 8);
                    this.values.put(key, value);
                }
                Arrays.sort(this.keys);
            }

            void clean() {
                IntToIntBtree btree = this.nodeView.btree;
                for (int i = 0; i < btree.hashPageCapacity; ++i) {
                    this.nodeView.hashSetState(i, 0);
                }
            }
        }
    }

    static class BtreePage {
        protected final IntToIntBtree btree;
        protected int address = -1;
        private short myChildrenCount;
        protected int myAddressInBuffer;
        protected ByteBuffer myBuffer;

        public BtreePage(IntToIntBtree btree) {
            this.btree = btree;
            this.myChildrenCount = (short)-1;
        }

        void setAddress(int _address) {
            this.address = _address;
            this.syncWithStore();
        }

        protected void syncWithStore() {
            this.myChildrenCount = (short)-1;
            PagedFileStorage pagedFileStorage = this.btree.storage.getPagedFileStorage();
            this.myAddressInBuffer = pagedFileStorage.getOffsetInPage(this.address);
            this.myBuffer = pagedFileStorage.getByteBuffer(this.address);
        }

        protected final void setFlag(int mask, boolean flag) {
            byte b = this.myBuffer.get(this.myAddressInBuffer);
            b = flag ? (byte)(b | mask) : (byte)(b & ~mask);
            this.myBuffer.put(this.myAddressInBuffer, b);
        }

        protected final short getChildrenCount() {
            if (this.myChildrenCount == -1) {
                this.myChildrenCount = this.myBuffer.getShort(this.myAddressInBuffer + 1);
            }
            return this.myChildrenCount;
        }

        protected final void setChildrenCount(short value) {
            this.myChildrenCount = value;
            this.myBuffer.putShort(this.myAddressInBuffer + 1, value);
        }

        protected final void setNextPage(int nextPage) {
            this.putInt(3, nextPage);
        }

        protected final int getNextPage() {
            return this.getInt(3);
        }

        protected final int getInt(int address) {
            return this.myBuffer.getInt(this.myAddressInBuffer + address);
        }

        protected final void putInt(int offset, int value) {
            this.myBuffer.putInt(this.myAddressInBuffer + offset, value);
        }

        protected final ByteBuffer getBytes(int address, int length) {
            ByteBuffer duplicate = this.myBuffer.duplicate();
            int newPosition = address + this.myAddressInBuffer;
            duplicate.position(newPosition);
            duplicate.limit(newPosition + length);
            return duplicate;
        }

        protected final void putBytes(int address, ByteBuffer buffer) {
            this.myBuffer.position(address + this.myAddressInBuffer);
            this.myBuffer.put(buffer);
        }
    }

    static interface BtreeDataStorage {
        public int persistInt(int var1, int var2, boolean var3);
    }
}

