/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.jetbrains.annotations.NotNull;

public class IOUtil {
    private IOUtil() {
    }

    public static String readString(DataInput stream) throws IOException {
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        char[] chars = new char[length];
        byte[] bytes = new byte[length * 2];
        stream.readFully(bytes);
        int i = 0;
        int i2 = 0;
        while (i < length) {
            chars[i] = (char)((bytes[i2] << 8) + (bytes[i2 + 1] & 0xFF));
            ++i;
            i2 += 2;
        }
        return new String(chars);
    }

    public static void writeString(String s, DataOutput stream) throws IOException {
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        if (s.length() == 0) {
            stream.writeInt(0);
            return;
        }
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        stream.writeInt(chars.length);
        int i = 0;
        int i2 = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    public static void writeUTFTruncated(DataOutput stream, String text) throws IOException {
        if (text.length() > 16383) {
            stream.writeUTF(text.substring(0, 16383));
        } else {
            stream.writeUTF(text);
        }
    }

    public static byte[] allocReadWriteUTFBuffer() {
        return new byte[256];
    }

    public static void writeUTFFast(byte[] buffer, DataOutput storage, @NotNull String value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/io/IOUtil.writeUTFFast must not be null");
        }
        int len = value.length();
        if (len < 255 && IOUtil.isAscii(value)) {
            buffer[0] = (byte)len;
            for (int i = 0; i < len; ++i) {
                buffer[i + 1] = (byte)value.charAt(i);
            }
            storage.write(buffer, 0, len + 1);
        } else {
            storage.writeByte(-1);
            try {
                storage.writeUTF(value);
            }
            catch (UTFDataFormatException e) {
                storage.writeUTF("LONGER_THAN_64K");
                IOUtil.writeString(value, storage);
            }
        }
    }

    public static String readUTFFast(byte[] buffer, DataInput storage) throws IOException {
        int len = 0xFF & storage.readByte();
        if (len == 255) {
            String result = storage.readUTF();
            if ("LONGER_THAN_64K".equals(result)) {
                return IOUtil.readString(storage);
            }
            return result;
        }
        char[] chars = new char[len];
        storage.readFully(buffer, 0, len);
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)buffer[i];
        }
        return new String(chars);
    }

    public static boolean isAscii(String str) {
        for (int i = 0; i != str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u0000' && c < '\u0080') continue;
            return false;
        }
        return true;
    }
}

