/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.io;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;

public abstract class BaseOutputReader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.BaseOutputReader");
    protected final Reader myReader;
    protected volatile boolean isStopped;
    private final char[] myBuffer;
    private boolean skipLF;
    private Future<?> myFinishedFuture;

    public BaseOutputReader(@NotNull Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/BaseOutputReader.<init> must not be null");
        }
        this.isStopped = false;
        this.myBuffer = new char[8192];
        this.skipLF = false;
        this.myFinishedFuture = null;
        this.myReader = reader;
    }

    protected void start() {
        if (this.myFinishedFuture == null) {
            this.myFinishedFuture = this.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    BaseOutputReader.this.doRun();
                }
            });
        }
    }

    protected abstract Future<?> executeOnPooledThread(Runnable var1);

    protected void doRun() {
        try {
            while (true) {
                boolean read = this.readAvailable();
                if (this.isStopped) {
                    this.myReader.close();
                    break;
                }
                Thread.sleep(read ? 1L : 5L);
            }
        }
        catch (InterruptedException read) {
        }
        catch (IOException e) {
            LOG.info(e);
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    protected synchronized boolean readAvailable() throws IOException {
        int n;
        char[] buffer = this.myBuffer;
        StringBuilder token = new StringBuilder();
        boolean read = false;
        while (this.myReader.ready() && (n = this.myReader.read(buffer)) > 0) {
            read = true;
            for (int i = 0; i < n; ++i) {
                char c = buffer[i];
                if (this.skipLF && c != '\n') {
                    token.append('\r');
                }
                if (c == '\r') {
                    this.skipLF = true;
                } else {
                    this.skipLF = false;
                    token.append(c);
                }
                if (c != '\n') continue;
                this.onTextAvailable(token.toString());
                token.setLength(0);
            }
        }
        if (token.length() != 0) {
            this.onTextAvailable(token.toString());
            token.setLength(0);
        }
        return read;
    }

    protected abstract void onTextAvailable(@NotNull String var1);

    public void stop() {
        this.isStopped = true;
    }

    public void waitFor() throws InterruptedException {
        try {
            this.myFinishedFuture.get();
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
    }
}

