/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.indexing;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.LanguageSubstitutors;

public class SubstitutedFileType
extends LanguageFileType {
    @NotNull
    private final FileType originalFileType;
    @NotNull
    private final FileType fileType;

    private SubstitutedFileType(@NotNull FileType originalFileType, @NotNull LanguageFileType substitutionFileType) {
        if (originalFileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/SubstitutedFileType.<init> must not be null");
        }
        if (substitutionFileType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/SubstitutedFileType.<init> must not be null");
        }
        super(substitutionFileType.getLanguage());
        this.originalFileType = originalFileType;
        this.fileType = substitutionFileType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static FileType substituteFileType(VirtualFile file, @NotNull FileType fileType, Project project) {
        FileType fileType2;
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/SubstitutedFileType.substituteFileType must not be null");
        }
        if (project == null) {
            fileType2 = fileType;
            if (fileType2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SubstitutedFileType.substituteFileType must not return null");
            return fileType2;
        }
        if (fileType instanceof LanguageFileType) {
            Language language = ((LanguageFileType)fileType).getLanguage();
            Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, file, project);
            LanguageFileType substFileType = substitutedLanguage.getAssociatedFileType();
            if (!substitutedLanguage.equals(language) && substFileType != null) {
                fileType2 = new SubstitutedFileType(fileType, substFileType);
                if (fileType2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SubstitutedFileType.substituteFileType must not return null");
                return fileType2;
            }
        }
        if ((fileType2 = fileType) != null) return fileType2;
        throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SubstitutedFileType.substituteFileType must not return null");
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.fileType.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SubstitutedFileType.getName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.fileType.getDescription();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SubstitutedFileType.getDescription must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        String string = this.fileType.getDefaultExtension();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SubstitutedFileType.getDefaultExtension must not return null");
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return this.fileType.getIcon();
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/SubstitutedFileType.getCharset must not be null");
        }
        return this.fileType.getCharset(file, content);
    }

    @NotNull
    public FileType getOriginalFileType() {
        FileType fileType = this.originalFileType;
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SubstitutedFileType.getOriginalFileType must not return null");
        }
        return fileType;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.fileType;
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SubstitutedFileType.getFileType must not return null");
        }
        return fileType;
    }
}

