/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.indexing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jet.internal.com.intellij.openapi.application.PathManager;
import org.jetbrains.jet.internal.gnu.trove.TIntObjectHashMap;
import org.jetbrains.jet.internal.gnu.trove.TObjectIntHashMap;
import org.jetbrains.jet.internal.gnu.trove.TObjectIntProcedure;

public class ID<K, V> {
    private static final TIntObjectHashMap<ID> ourRegistry = new TIntObjectHashMap();
    private static final TObjectIntHashMap<String> ourNameToIdRegistry = new TObjectIntHashMap();
    private final String myName;
    private final short myUniqueId;

    private static File getEnumFile() {
        File indexFolder = PathManager.getIndexRoot();
        return new File(indexFolder, "indices.enum");
    }

    protected ID(String name) {
        this.myName = name;
        this.myUniqueId = ID.stringToId(name);
        ID old = ourRegistry.put(this.myUniqueId, this);
        assert (old == null);
    }

    private static short stringToId(String name) {
        if (ourNameToIdRegistry.containsKey(name)) {
            return (short)ourNameToIdRegistry.get(name);
        }
        int n = ourNameToIdRegistry.size() + 1;
        assert (n <= Short.MAX_VALUE) : "Number of indices exceeded";
        ourNameToIdRegistry.put(name, n);
        ID.writeEnumFile();
        return (short)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEnumFile() {
        try {
            File f = ID.getEnumFile();
            BufferedWriter w = new BufferedWriter(new FileWriter(f));
            try {
                final String[] names = new String[ourNameToIdRegistry.size()];
                ourNameToIdRegistry.forEachEntry(new TObjectIntProcedure<String>(){

                    @Override
                    public boolean execute(String key, int value) {
                        names[value - 1] = key;
                        return true;
                    }
                });
                for (String name : names) {
                    w.write(name);
                    w.newLine();
                }
            }
            finally {
                w.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> ID<K, V> create(@NonNls String name) {
        short id = ID.stringToId(name);
        ID<?, ?> found = ID.findById(id);
        if (found != null) {
            return found;
        }
        return new ID<K, V>(name);
    }

    public int hashCode() {
        return this.myUniqueId;
    }

    public String toString() {
        return this.myName;
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    public static ID<?, ?> findById(int id) {
        return ourRegistry.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File indicies = ID.getEnumFile();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(indicies));
            try {
                int cnt = 0;
                while (true) {
                    ++cnt;
                    String name = reader.readLine();
                    if (name == null) {
                        break;
                    }
                    ourNameToIdRegistry.put(name, cnt);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            ourNameToIdRegistry.clear();
            ID.writeEnumFile();
        }
    }
}

