/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.indexing;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.jet.internal.com.intellij.openapi.project.DefaultProjectFactory;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.LanguageSubstitutors;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFileFactory;
import org.jetbrains.jet.internal.com.intellij.util.indexing.FileContent;
import org.jetbrains.jet.internal.com.intellij.util.indexing.IndexingDataKeys;
import org.jetbrains.jet.internal.com.intellij.util.indexing.SubstitutedFileType;

public final class FileContentImpl
extends UserDataHolderBase
implements FileContent {
    private final VirtualFile myFile;
    private final String myFileName;
    private final FileType myFileType;
    private final Charset myCharset;
    private byte[] myContent;
    private CharSequence myContentAsText;
    private static final Key<PsiFile> CACHED_PSI = Key.create("cached psi from content");

    @Override
    public Project getProject() {
        return this.getUserData(IndexingDataKeys.PROJECT);
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psi = this.getUserData(IndexingDataKeys.PSI_FILE);
        if (psi == null) {
            psi = this.getUserData(CACHED_PSI);
        }
        if (psi == null) {
            Project project = this.getProject();
            if (project == null) {
                project = DefaultProjectFactory.getInstance().getDefaultProject();
            }
            Language language = ((LanguageFileType)this.getFileTypeWithoutSubstitution()).getLanguage();
            Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, this.getFile(), project);
            psi = PsiFileFactory.getInstance(project).createFileFromText(this.getFileName(), substitutedLanguage, this.getContentAsText(), false, false, true);
            psi.putUserData(IndexingDataKeys.VIRTUAL_FILE, this.getFile());
            this.putUserData(CACHED_PSI, psi);
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getPsiFile must not return null");
        }
        return psiFile;
    }

    public FileContentImpl(@NotNull VirtualFile file, @NotNull CharSequence contentAsText, Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileContentImpl.<init> must not be null");
        }
        if (contentAsText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/FileContentImpl.<init> must not be null");
        }
        this(file, contentAsText, null, charset);
    }

    public FileContentImpl(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileContentImpl.<init> must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/FileContentImpl.<init> must not be null");
        }
        this(file, null, content, LoadTextUtil.detectCharsetAndSetBOM(file, content));
    }

    public FileContentImpl(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileContentImpl.<init> must not be null");
        }
        this(file, null, null, null);
    }

    private FileContentImpl(@NotNull VirtualFile file, CharSequence contentAsText, byte[] content, Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileContentImpl.<init> must not be null");
        }
        this.myFile = file;
        this.myContentAsText = contentAsText;
        this.myContent = content;
        this.myCharset = charset;
        this.myFileType = file.getFileType();
        this.myFileName = file.getName();
    }

    @NotNull
    private FileType substituteFileType(VirtualFile file, FileType fileType) {
        Project project = this.getProject();
        FileType fileType2 = SubstitutedFileType.substituteFileType(file, fileType, project);
        if (fileType2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.substituteFileType must not return null");
        }
        return fileType2;
    }

    @NotNull
    public FileType getSubstitutedFileType() {
        FileType fileType = this.substituteFileType(this.myFile, this.myFileType);
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getSubstitutedFileType must not return null");
        }
        return fileType;
    }

    public static FileContent createByFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileContentImpl.createByFile must not be null");
        }
        try {
            return new FileContentImpl(file, file.contentsToByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FileType getFileTypeWithoutSubstitution() {
        return this.myFileType;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getSubstitutedFileType();
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getFileType must not return null");
        }
        return fileType;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getFile must not return null");
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getFileName must not return null");
        }
        return string;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    @Override
    public byte[] getContent() {
        if (this.myContent == null && this.myContentAsText != null) {
            try {
                this.myContent = this.myCharset != null ? ((Object)this.myContentAsText).toString().getBytes(this.myCharset.name()) : ((Object)this.myContentAsText).toString().getBytes();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.myContent;
    }

    @Override
    public CharSequence getContentAsText() {
        if (this.myFileType.isBinary()) {
            throw new IllegalDataException("Cannot obtain text for binary file type : " + this.myFileType.getDescription());
        }
        CharSequence content = this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content != null) {
            return content;
        }
        if (this.myContentAsText == null && this.myContent != null) {
            this.myContentAsText = LoadTextUtil.getTextByBinaryPresentation(this.myContent, this.myCharset);
        }
        return this.myContentAsText;
    }

    public String toString() {
        return this.myFileName;
    }

    public static class IllegalDataException
    extends RuntimeException {
        public IllegalDataException(String message) {
            super(message);
        }
    }
}

