/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;

public final class VariableWidthIntArray
implements Cloneable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.containers.VariableWidthIntArray");
    private int[] intArray = null;
    private short[] shortArray = null;
    private byte[] byteArray = null;
    private final int minValue;
    private final int maxValue;
    private final int arrayType;

    public VariableWidthIntArray(int minValue, int maxValue, int initialCapacity) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (minValue < Short.MIN_VALUE || maxValue > Short.MAX_VALUE) {
            this.intArray = new int[VariableWidthIntArray.bestSize(initialCapacity)];
            this.arrayType = 1;
        } else if (minValue < -128 || maxValue > 127) {
            this.shortArray = new short[VariableWidthIntArray.bestSize(initialCapacity)];
            this.arrayType = 2;
        } else {
            this.byteArray = new byte[VariableWidthIntArray.bestSize(initialCapacity)];
            this.arrayType = 3;
        }
    }

    static int bestSize(int maxSize) {
        int newSize = (int)((double)maxSize * 5.0 / 4.0);
        return newSize <= maxSize ? maxSize + 1 : newSize;
    }

    public void ensureArraySize(int index) {
        if (this.intArray != null && this.intArray.length <= index) {
            int[] tmp = new int[VariableWidthIntArray.bestSize(index)];
            System.arraycopy(this.intArray, 0, tmp, 0, this.intArray.length);
            this.intArray = tmp;
        } else if (this.shortArray != null && this.shortArray.length <= index) {
            short[] tmp = new short[VariableWidthIntArray.bestSize(index)];
            System.arraycopy(this.shortArray, 0, tmp, 0, this.shortArray.length);
            this.shortArray = tmp;
        } else if (this.byteArray.length <= index) {
            byte[] tmp = new byte[VariableWidthIntArray.bestSize(index)];
            System.arraycopy(this.byteArray, 0, tmp, 0, this.byteArray.length);
            this.byteArray = tmp;
        }
    }

    public int get(int index) {
        switch (this.arrayType) {
            case 1: {
                return this.intArray[index];
            }
            case 2: {
                return this.shortArray[index];
            }
            case 3: {
                return this.byteArray[index];
            }
        }
        LOG.error("No array allocated");
        return 0;
    }

    public void put(int index, int value) {
        if (value < this.minValue || value > this.maxValue) {
            LOG.error("Value out of domain");
        }
        switch (this.arrayType) {
            case 1: {
                this.intArray[index] = value;
                return;
            }
            case 2: {
                this.shortArray[index] = (short)value;
                return;
            }
            case 3: {
                this.byteArray[index] = (byte)value;
                return;
            }
        }
        LOG.error("No array allocated");
    }

    public Object clone() throws CloneNotSupportedException {
        VariableWidthIntArray arr = (VariableWidthIntArray)super.clone();
        if (this.intArray != null) {
            arr.intArray = (int[])this.intArray.clone();
        }
        if (this.shortArray != null) {
            arr.shortArray = (short[])this.shortArray.clone();
        }
        if (this.byteArray != null) {
            arr.byteArray = (byte[])this.byteArray.clone();
        }
        return arr;
    }

    public void arraycopy(int[] src, int from, int to, int count) {
        for (int i = 0; i < count; ++i) {
            this.put(i + to, src[i + from]);
        }
    }

    public void move(int from, int to, int count) {
        switch (this.arrayType) {
            case 1: {
                System.arraycopy(this.intArray, from, this.intArray, to, count);
                break;
            }
            case 2: {
                System.arraycopy(this.shortArray, from, this.shortArray, to, count);
                break;
            }
            case 3: {
                System.arraycopy(this.byteArray, from, this.byteArray, to, count);
                break;
            }
            default: {
                LOG.error("Invalid array type");
            }
        }
    }

    public boolean arrayequal(VariableWidthIntArray src, int srcfrom, int from, int count) {
        if (src.arrayType != this.arrayType) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (this.get(from + i) == src.get(srcfrom + i)) continue;
            return false;
        }
        return true;
    }
}

