/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.intellij.reference.SoftReference;
import org.jetbrains.jet.internal.gnu.trove.THashMap;

public final class SoftValueHashMap<K, V>
implements Map<K, V> {
    private final THashMap<K, MyReference<K, V>> myMap;
    private final ReferenceQueue<MyReference<K, V>> myQueue = new ReferenceQueue();

    public SoftValueHashMap() {
        this.myMap = new THashMap();
    }

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            if (this.myMap.get(ref.key) != ref) continue;
            this.myMap.remove(ref.key);
        }
        return;
    }

    @Override
    public V get(Object key) {
        MyReference<K, V> ref = this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        MyReference<K, V> oldRef = this.myMap.put(key, new MyReference<K, V>(key, value, this.myQueue));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyReference<K, V> ref = this.myMap.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("method not implemented");
    }

    private static class MyReference<K, V>
    extends SoftReference<V> {
        final K key;

        public MyReference(K key, V referent, ReferenceQueue q) {
            super(referent, q);
            this.key = key;
        }
    }
}

