/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.jet.internal.com.intellij.util.ObjectUtils;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentWeakHashMap;

public abstract class SoftFactoryMap<T, V> {
    private final ConcurrentMap<T, SoftReference<V>> myMap = new ConcurrentWeakHashMap<T, SoftReference<V>>();

    protected abstract V create(T var1);

    public final V get(T key) {
        Object v;
        SoftReference reference = (SoftReference)this.myMap.get(key);
        if (reference != null && (v = reference.get()) != null) {
            return v == ObjectUtils.NULL ? null : (V)v;
        }
        V value = this.create(key);
        SoftReference<Object> valueRef = new SoftReference<Object>(value == null ? ObjectUtils.NULL : value);
        SoftReference<Object> prevRef = this.myMap.putIfAbsent(key, valueRef);
        Object prev = prevRef == null ? null : prevRef.get();
        return (V)(prev == null || prev == ObjectUtils.NULL ? value : prev);
    }

    public final boolean containsKey(T key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }
}

