/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import java.util.Map;
import org.jetbrains.jet.internal.com.intellij.util.PairProcessor;
import org.jetbrains.jet.internal.com.intellij.util.containers.SoftHashMap;
import org.jetbrains.jet.internal.gnu.trove.TObjectHashingStrategy;

public class SoftArrayHashMap<T, V>
implements Cloneable {
    private SoftHashMap<T, SoftArrayHashMap<T, V>> myContinuationMap;
    private SoftHashMap<T, V> myValuesMap;
    private V myEmptyValue;
    private final TObjectHashingStrategy<T> myStrategy;

    public SoftArrayHashMap() {
        this(TObjectHashingStrategy.CANONICAL);
    }

    public SoftArrayHashMap(TObjectHashingStrategy<T> strategy) {
        this.myStrategy = strategy;
    }

    private V get(T[] array, int index) {
        SoftArrayHashMap<T, V> map;
        if (index == array.length - 1) {
            return this.myValuesMap != null ? (V)this.myValuesMap.get(array[index]) : null;
        }
        if (this.myContinuationMap != null && (map = this.myContinuationMap.get(array[index])) != null) {
            return super.get(array, index + 1);
        }
        return null;
    }

    public final V get(T[] key) {
        if (key.length == 0) {
            return this.myEmptyValue;
        }
        return this.get(key, 0);
    }

    public boolean processLeafEntries(PairProcessor<T, V> processor) {
        if (this.myValuesMap != null) {
            for (Object t : this.myValuesMap.keySet()) {
                if (processor.process(t, this.myValuesMap.get(t))) continue;
                return false;
            }
        }
        if (this.myContinuationMap != null) {
            for (SoftArrayHashMap map : this.myContinuationMap.values()) {
                if (map.processLeafEntries(processor)) continue;
                return false;
            }
        }
        return true;
    }

    private void put(T[] array, int index, V value) {
        T key = array[index];
        if (index == array.length - 1) {
            if (this.myValuesMap == null) {
                this.myValuesMap = new SoftHashMap(this.myStrategy);
            }
            this.myValuesMap.put(key, value);
        } else {
            SoftArrayHashMap<T, V> softArrayHashMap;
            if (this.myContinuationMap == null) {
                this.myContinuationMap = new SoftHashMap(this.myStrategy);
            }
            if ((softArrayHashMap = this.myContinuationMap.get(key)) == null) {
                softArrayHashMap = new SoftArrayHashMap<T, V>(this.myStrategy);
                this.myContinuationMap.put(key, softArrayHashMap);
            }
            super.put(array, index + 1, value);
        }
    }

    public final void put(T[] key, V value) {
        if (key.length == 0) {
            this.myEmptyValue = value;
        } else {
            this.put(key, 0, value);
        }
    }

    public final void clear() {
        this.myContinuationMap = null;
        this.myValuesMap = null;
        this.myEmptyValue = null;
    }

    public final boolean containsKey(T[] path) {
        return this.get(path) != null;
    }

    public final SoftArrayHashMap<T, V> clone() {
        SoftArrayHashMap<T, V> copy = new SoftArrayHashMap<T, V>(this.myStrategy);
        copy.myContinuationMap = this.copyMap(this.myContinuationMap);
        copy.myValuesMap = this.copyMap(this.myValuesMap);
        copy.myEmptyValue = this.myEmptyValue;
        return copy;
    }

    private <X> SoftHashMap<T, X> copyMap(SoftHashMap<T, X> map) {
        SoftHashMap<T, X> copy = new SoftHashMap<T, X>();
        for (Map.Entry<T, X> entry : map.entrySet()) {
            copy.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }
}

