/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.containers.EmptyIterator;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;

public class MultiMap<K, V>
implements Serializable {
    public static final MultiMap EMPTY = new MultiMap(){

        protected Map createMap() {
            return Collections.emptyMap();
        }
    };
    private final Map<K, Collection<V>> myMap;
    private Collection<V> values;

    public MultiMap() {
        this.myMap = this.createMap();
    }

    public MultiMap(int i, float v) {
        this.myMap = this.createMap(i, v);
    }

    protected Map<K, Collection<V>> createMap() {
        return new HashMap();
    }

    protected Map<K, Collection<V>> createMap(int i, float v) {
        return new HashMap(i, v);
    }

    protected Collection<V> createCollection() {
        return new ArrayList();
    }

    protected Collection<V> createEmptyCollection() {
        return Collections.emptyList();
    }

    public <Kk extends K, Vv extends V> void putAllValues(MultiMap<Kk, Vv> from) {
        for (Map.Entry<Kk, Collection<Vv>> entry : from.entrySet()) {
            this.putValues(entry.getKey(), entry.getValue());
        }
    }

    public void putValues(K key, Collection<? extends V> values) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.addAll(values);
    }

    public void putValue(K key, V value) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.add(value);
    }

    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.myMap.entrySet();
    }

    public boolean isEmpty() {
        if (this.myMap.isEmpty()) {
            return true;
        }
        for (Collection<V> valueList : this.myMap.values()) {
            if (valueList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    public boolean containsScalarValue(V value) {
        for (Collection<V> valueList : this.myMap.values()) {
            if (!valueList.contains(value)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        Collection<V> collection2 = collection == null ? this.createEmptyCollection() : collection;
        if (collection2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/MultiMap.get must not return null");
        }
        return collection2;
    }

    @NotNull
    public Collection<V> getModifiable(K key) {
        Collection<V> collection = this.myMap.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.myMap.put(key, collection);
        }
        Collection<V> collection2 = collection;
        if (collection2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/MultiMap.getModifiable must not return null");
        }
        return collection2;
    }

    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    public int size() {
        return this.myMap.size();
    }

    public void put(K key, Collection<V> values) {
        this.myMap.put(key, values);
    }

    public void removeValue(K key, V value) {
        Collection<V> values = this.myMap.get(key);
        if (values != null) {
            values.remove(value);
            if (values.isEmpty()) {
                this.myMap.remove(key);
            }
        }
    }

    public Collection<? extends V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private Iterator<Collection<V>> mapIterator;
                        private Iterator<V> itr;
                        {
                            this.mapIterator = MultiMap.this.myMap.values().iterator();
                            this.itr = EmptyIterator.getInstance();
                        }

                        @Override
                        public boolean hasNext() {
                            while (!this.itr.hasNext()) {
                                if (!this.mapIterator.hasNext()) {
                                    return false;
                                }
                                this.itr = this.mapIterator.next().iterator();
                            }
                            return true;
                        }

                        @Override
                        public V next() {
                            while (!this.itr.hasNext()) {
                                if (!this.mapIterator.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                this.itr = this.mapIterator.next().iterator();
                            }
                            return this.itr.next();
                        }

                        @Override
                        public void remove() {
                            this.itr.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    int res = 0;
                    for (Collection vs : MultiMap.this.myMap.values()) {
                        res += vs.size();
                    }
                    return res;
                }

                @Override
                public boolean contains(Object o) {
                    for (Collection vs : MultiMap.this.myMap.values()) {
                        if (!vs.contains(o)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.values;
    }

    public void clear() {
        this.myMap.clear();
    }

    public Collection<V> remove(K key) {
        return this.myMap.remove(key);
    }

    @NotNull
    public static <K, V> MultiMap<K, V> emptyInstance() {
        MultiMap empty;
        MultiMap multiMap = empty = EMPTY;
        if (multiMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/MultiMap.emptyInstance must not return null");
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create() {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        if (multiMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/MultiMap.create must not return null");
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create(int i, float v) {
        MultiMap<K, V> multiMap = new MultiMap<K, V>(i, v);
        if (multiMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/MultiMap.create must not return null");
        }
        return multiMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiMap)) {
            return false;
        }
        return ((Object)this.myMap).equals(((MultiMap)o).myMap);
    }

    public int hashCode() {
        return ((Object)this.myMap).hashCode();
    }

    public String toString() {
        return this.myMap.toString();
    }
}

