/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.util.containers;

import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.gnu.trove.TIntHashSet;
import org.jetbrains.jet.internal.gnu.trove.TIntIntHashMap;
import org.jetbrains.jet.internal.gnu.trove.TIntObjectHashMap;

public class IntToIntSetMap {
    private final TIntIntHashMap mySingle;
    private final TIntObjectHashMap<TIntHashSet> myMulti;

    public IntToIntSetMap(int initialCapacity, float loadfactor) {
        this.mySingle = new TIntIntHashMap(initialCapacity, loadfactor);
        this.myMulti = new TIntObjectHashMap(initialCapacity, loadfactor);
    }

    public void addOccurence(int key, int value) {
        if (this.mySingle.containsKey(key)) {
            int old = this.mySingle.get(key);
            TIntHashSet items = new TIntHashSet(3);
            items.add(old);
            items.add(value);
            this.mySingle.remove(key);
            this.myMulti.put(key, items);
            return;
        }
        TIntHashSet items = this.myMulti.get(key);
        if (items != null) {
            items.add(value);
            return;
        }
        this.mySingle.put(key, value);
    }

    public void removeOccurence(int key, int value) {
        if (this.mySingle.containsKey(key)) {
            this.mySingle.remove(key);
            return;
        }
        TIntHashSet items = this.myMulti.get(key);
        if (items != null) {
            items.remove(value);
            if (items.size() == 1) {
                this.mySingle.put(key, items.toArray()[0]);
                this.myMulti.remove(key);
            }
        }
    }

    public int[] get(int key) {
        if (this.mySingle.containsKey(key)) {
            return new int[]{this.mySingle.get(key)};
        }
        TIntHashSet items = this.myMulti.get(key);
        if (items == null) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        return items.toArray();
    }
}

